/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.dialogs;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.polarsys.capella.common.ui.toolkit.dialogs.TransferTreeListDialog;
import org.polarsys.capella.common.ui.toolkit.viewers.data.AbstractData;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataLabelProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.MultipleValidElementsTreeData;
import org.polarsys.capella.common.ui.toolkit.viewers.transfer.OrderedTransferTreeListViewer;
import org.polarsys.capella.common.ui.toolkit.viewers.transfer.TransferTreeListViewer;
import org.polarsys.capella.common.ui.toolkit.widgets.handler.SelectionChangedHandler;

public class OrderedTransferTreeListDialog
extends TransferTreeListDialog {
    public OrderedTransferTreeListDialog(Shell parentShell, TransactionalEditingDomain editingDomain, AdapterFactory adapterFactory, String dialogTitle, String dialogMessage) {
        super(parentShell, dialogTitle, dialogMessage, editingDomain, adapterFactory);
    }

    public OrderedTransferTreeListDialog(Shell parentShell, String dialogTitle, String dialogMessage, DataLabelProvider leftLabelProvider, DataLabelProvider rightLabelProvider, int leftViewerStyle, int rightViewerStyle) {
        super(parentShell, dialogTitle, dialogMessage, leftLabelProvider, rightLabelProvider, leftViewerStyle, rightViewerStyle);
    }

    @Override
    protected AbstractData createRightViewerData(List<? extends EObject> elements, Object context) {
        return new MultipleValidElementsTreeData(elements, context);
    }

    @Override
    protected TransferTreeListViewer createTransferTreeListViewer(Composite parent) {
        return new OrderedTransferTreeListViewer(parent, 126, this.getLeftViewerStyle(), this.getRightViewerStyle());
    }

    protected boolean handleSelectionForUpAndDownButton(AbstractData input, ISelection selection, boolean isMovingUp) {
        TreeItem[] treeItems;
        boolean result;
        boolean bl = result = !selection.isEmpty();
        if (!result) {
            return result;
        }
        Tree tree = this.getTransferViewer().getRightViewer().getTree();
        TreeItem[] treeItemArray = treeItems = tree.getSelection();
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            Object data = treeItem.getData();
            if (input.isValid(data)) {
                int itemCount;
                int index;
                TreeItem parentItems = treeItem.getParentItem();
                int n3 = index = parentItems != null ? parentItems.indexOf(treeItem) : tree.indexOf(treeItem);
                if (index == 0 && isMovingUp) {
                    result = false;
                    break;
                }
                int n4 = itemCount = parentItems != null ? parentItems.getItemCount() : tree.getItemCount();
                if (index == itemCount - 1 && !isMovingUp) {
                    result = false;
                    break;
                }
            } else {
                result = false;
                break;
            }
            ++n2;
        }
        return result;
    }

    @Override
    protected void initializeRightViewer(TransferTreeListViewer transferViewer) {
        super.initializeRightViewer(transferViewer);
        this.getTransferViewer().getRightViewer().setSorter(null);
    }

    @Override
    protected void registerSelectionHandler(final TransferTreeListViewer transferViewer) {
        transferViewer.setSelectionChangedHandler(new SelectionChangedHandler(){

            @Override
            protected boolean doHandleSelection(ISelection selection) {
                return OrderedTransferTreeListDialog.this.handleSelectionForUpAndDownButton(transferViewer.getRightInput(), selection, true);
            }
        }, 1024);
        transferViewer.setSelectionChangedHandler(new SelectionChangedHandler(){

            @Override
            protected boolean doHandleSelection(ISelection selection) {
                return OrderedTransferTreeListDialog.this.handleSelectionForUpAndDownButton(transferViewer.getRightInput(), selection, false);
            }
        }, 2048);
        super.registerSelectionHandler(transferViewer);
    }
}

