/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.business.queries.ju;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.osgi.framework.FrameworkUtil;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.test.business.queries.ju.BQTestCaseValidator;
import org.polarsys.capella.test.business.queries.ju.BQTestHelpers;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.log.FormatedLogger;
import org.polarsys.capella.test.framework.helpers.log.FormatedSysoutLogger;
import org.polarsys.capella.test.framework.helpers.log.SilentLogger;

public abstract class BQTestCase
extends BasicTestCase {
    protected FormatedLogger logger = new FormatedSysoutLogger();

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.getProjectForTest());
    }

    public abstract String getProjectForTest();

    public abstract String getBQFullQualifiedName();

    public File getTestSuiteFile() {
        return BQTestHelpers.getTestSuiteFile(this.getPluginFolder(), this.getBQFullQualifiedName(), this.getProjectForTest());
    }

    public void test() throws Exception {
        File testSuiteFile;
        String queryIdentifier = this.getBQFullQualifiedName();
        IBusinessQuery businessQuery = BQTestHelpers.instanciateBQ(FrameworkUtil.getBundle(((Object)((Object)this)).getClass()), queryIdentifier);
        if (businessQuery == null) {
            BQTestCase.assertTrue((String)NLS.bind((String)"Impossible to instanciate business query: {0}", (Object)queryIdentifier), (boolean)false);
        }
        if ((testSuiteFile = this.getTestSuiteFile()) == null || !testSuiteFile.exists()) {
            BQTestCase.assertTrue((String)NLS.bind((String)"test suite file does not exist ({0})", (Object)testSuiteFile), (boolean)false);
        }
        Session sessionForTest = this.getSessionForTestModel(this.getProjectForTest());
        this.logger.addTextLn((Object)(">> Test validation for query " + queryIdentifier));
        BQTestCaseValidator validator = new BQTestCaseValidator();
        boolean result = validator.process((FormatedLogger)new SilentLogger(), queryIdentifier, businessQuery, testSuiteFile, sessionForTest);
        String message = validator.getResultDescription();
        this.logger.incIndent();
        this.logger.addTextLn((Object)message);
        this.logger.decIndent();
        BQTestCase.assertTrue((String)message.toString(), (boolean)result);
    }
}

