/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.business.queries.ju;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.test.business.queries.ju.BQTestHelpers;
import org.polarsys.capella.test.business.queries.ju.QueryResult;
import org.polarsys.capella.test.business.queries.ju.errors.BQValidationError;
import org.polarsys.capella.test.business.queries.ju.errors.InputNotFoundError;
import org.polarsys.capella.test.business.queries.ju.errors.InvalidMethodToCallTestCaseError;
import org.polarsys.capella.test.business.queries.ju.errors.MissingTestCaseError;
import org.polarsys.capella.test.business.queries.ju.errors.TestCaseFailsError;
import org.polarsys.capella.test.business.queries.ju.errors.TestCaseRaiseExceptionError;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.test.framework.helpers.log.FormatedLogger;

public class BQTestCaseValidator {
    private static final int MAX_FEEDBACK_BY_LINE = 40;
    protected FormatedLogger logger;
    protected List<BQValidationError> errors = new ArrayList<BQValidationError>();
    protected int nbFeedBack = 0;
    protected int nbTestCaseSucceed = 0;
    protected int nbInputNotFound = 0;
    protected int nbTestCaseFailed = 0;
    protected int nbRaisedExceptions = 0;
    protected int nbMissingTestCases = 0;
    protected int nbInvalidIdentifiers = 0;
    protected int nbTestCases = 0;

    public boolean process(FormatedLogger logger, String queryIdentifier, IBusinessQuery businessQuery, File testSuiteFile, Session testSession) {
        this.logger = logger;
        ArrayList<String> testedInputIdsForAvailable = new ArrayList<String>();
        ArrayList<String> testedInputIdsForCurrent = new ArrayList<String>();
        Hashtable<String, EObject> id2ObjectTable = BQTestHelpers.getId2ObjectTableInSessionForTest(testSession, businessQuery.getEClass());
        String serializedData = IResourceHelpers.readFileAsString((File)testSuiteFile);
        List<QueryResult> testCases = QueryResult.deserialize(serializedData);
        this.nbTestCases = testCases.size();
        for (QueryResult oracleResult : testCases) {
            String ident = oracleResult.getQueryIdentifier();
            EObject input = id2ObjectTable.get(oracleResult.getInputId());
            if (input == null) {
                this.declareInputNotFound(oracleResult.getInputId());
                continue;
            }
            List res = null;
            if (ident.endsWith("-getAvailableElements")) {
                testedInputIdsForAvailable.add(oracleResult.getInputId());
                try {
                    res = businessQuery.getAvailableElements(input);
                }
                catch (Throwable exception) {
                    this.declareExceptionRaised(exception, input, "getAvailableElements");
                }
            } else if (ident.endsWith("-getCurrentElements")) {
                testedInputIdsForCurrent.add(oracleResult.getInputId());
                try {
                    res = businessQuery.getCurrentElements(input, false);
                }
                catch (Throwable exception) {
                    this.declareExceptionRaised(exception, input, "getCurrentElements");
                }
            } else {
                this.declareInvalidMethodToCallInTestCase(ident);
            }
            QueryResult currentResult = QueryResult.createQueryResult(ident, input, res);
            if (!oracleResult.equals(currentResult)) {
                this.declareTestCaseFails(currentResult, oracleResult);
                continue;
            }
            this.declareTestOk();
        }
        for (String id : id2ObjectTable.keySet()) {
            if (testedInputIdsForAvailable.contains(id)) continue;
            this.declareMissingTestCase(id);
        }
        logger.carriageReturn();
        return this.errors.size() == 0;
    }

    protected void declareInputNotFound(String inputId) {
        ++this.nbInputNotFound;
        this.addTestCaseFeedBack('?');
        this.errors.add(new InputNotFoundError(inputId));
    }

    protected void declareExceptionRaised(Throwable exception, EObject input, String methodName) {
        ++this.nbRaisedExceptions;
        this.errors.add(new TestCaseRaiseExceptionError(exception, input, methodName));
    }

    protected void declareTestCaseFails(QueryResult currentResult, QueryResult oracleResult) {
        ++this.nbTestCaseFailed;
        this.addTestCaseFeedBack('-');
        this.errors.add(new TestCaseFailsError(currentResult, oracleResult));
    }

    protected void declareMissingTestCase(String objectId) {
        ++this.nbMissingTestCases;
        this.addTestCaseFeedBack('0');
        this.errors.add(new MissingTestCaseError(objectId));
    }

    protected void declareInvalidMethodToCallInTestCase(String methodName) {
        ++this.nbInvalidIdentifiers;
        this.addTestCaseFeedBack('#');
        this.errors.add(new InvalidMethodToCallTestCaseError(methodName));
    }

    protected void declareTestOk() {
        ++this.nbTestCaseSucceed;
        this.addTestCaseFeedBack('+');
    }

    protected void addTestCaseFeedBack(char feesback) {
        if (this.nbFeedBack >= 40) {
            this.logger.carriageReturn();
            this.nbFeedBack = 0;
        }
        ++this.nbFeedBack;
        this.logger.addText((Object)Character.valueOf(feesback));
    }

    public List<BQValidationError> getErrors() {
        return this.errors;
    }

    public int getNbTestCaseSucceed() {
        return this.nbTestCaseSucceed;
    }

    public int getNbInputNotFound() {
        return this.nbInputNotFound;
    }

    public int getNbTestCaseFailed() {
        return this.nbTestCaseFailed;
    }

    public int getNbRaisedExceptions() {
        return this.nbRaisedExceptions;
    }

    public int getNbMissingTestCases() {
        return this.nbMissingTestCases;
    }

    public int getNbInvalidIdentifiers() {
        return this.nbInvalidIdentifiers;
    }

    public int getNbTestCases() {
        return this.nbTestCases;
    }

    public String getResultDescription() {
        StringBuilder message = new StringBuilder();
        if (this.errors.size() == 0) {
            message.append("PASSED (" + this.nbTestCaseSucceed + " test cases)");
        } else {
            ArrayList<String> errorDescriptions = new ArrayList<String>();
            if (this.nbTestCaseFailed > 0) {
                errorDescriptions.add(String.valueOf(this.nbTestCaseFailed) + " test case(s) fail(s)");
            }
            if (this.nbInputNotFound > 0) {
                errorDescriptions.add(String.valueOf(this.nbInputNotFound) + " input not found");
            }
            if (this.nbRaisedExceptions > 0) {
                errorDescriptions.add(String.valueOf(this.nbRaisedExceptions) + " test case(s) raised exception(s)");
            }
            if (this.nbMissingTestCases > 0) {
                errorDescriptions.add(String.valueOf(this.nbMissingTestCases) + " missing test case(s)");
            }
            if (this.nbInvalidIdentifiers > 0) {
                errorDescriptions.add(String.valueOf(this.nbInvalidIdentifiers) + " invalid identifier(s)");
            }
            int i = 0;
            while (i < errorDescriptions.size()) {
                message.append((String)errorDescriptions.get(i));
                if (i < errorDescriptions.size() - 1) {
                    message.append(", ");
                }
                ++i;
            }
        }
        return message.toString();
    }
}

