/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.business.queries.ju;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.osgi.framework.Bundle;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.test.business.queries.ju.QueryResult;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;

public class BQTestHelpers {
    public static String getQueryClassification(String fqn, char separator) {
        List<String> segments = Arrays.asList(fqn.split("\\."));
        String folder = segments.get(segments.size() - 2);
        return folder;
    }

    public static Class<?> loadClass(Bundle bundle, String queryIdentifier) {
        try {
            Class<?> bqClass = null;
            if (bundle != null) {
                bqClass = bundle.loadClass(queryIdentifier);
            }
            if (bqClass == null) {
                bqClass = Class.forName(queryIdentifier);
            }
            return bqClass;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T newObject(Bundle bundle, String queryIdentifier) {
        try {
            return (T)BQTestHelpers.loadClass(bundle, queryIdentifier).getConstructors()[0].newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IBusinessQuery instanciateBQ(Bundle bundle, String queryIdentifier) {
        return (IBusinessQuery)BQTestHelpers.newObject(bundle, queryIdentifier);
    }

    public static Hashtable<String, EObject> createId2ObjectTable(List<EObject> elements) {
        Hashtable<String, EObject> table = new Hashtable<String, EObject>();
        for (EObject capellaElement : elements) {
            table.put(QueryResult.getObjectId(capellaElement), capellaElement);
        }
        return table;
    }

    public static String getFullQualifiedName(IFile javaFile) {
        String last;
        ArrayList<String> segs = new ArrayList<String>();
        String[] stringArray = javaFile.getFullPath().segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            segs.add(string);
            ++n2;
        }
        while (segs.size() > 0 && !((String)segs.get(0)).equals("src")) {
            segs.remove(0);
        }
        if (segs.size() > 0) {
            segs.remove(0);
        }
        if (segs.size() > 0 && (last = (String)segs.get(segs.size() - 1)).endsWith(".java")) {
            last = last.substring(0, last.length() - 5);
            segs.remove(segs.size() - 1);
            segs.add(last);
        }
        return StringUtils.join(segs, (char)'.');
    }

    public static Hashtable<String, EObject> getId2ObjectTableInSessionForTest(Session session, EClass clazz) {
        Hashtable<String, EObject> id2ObjectTable = new Hashtable<String, EObject>();
        for (EObject capellaElement : BQTestHelpers.getAllObjectsInSession(session, clazz)) {
            id2ObjectTable.put(QueryResult.getObjectId(capellaElement), capellaElement);
        }
        return id2ObjectTable;
    }

    public static List<EObject> getAllObjectsInSession(Session session, EClass clazz) {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        for (Resource semanticResource : session.getSemanticResources()) {
            TreeIterator treeIterator = semanticResource.getAllContents();
            while (treeIterator.hasNext()) {
                EObject obj = (EObject)treeIterator.next();
                if (!clazz.isInstance((Object)obj)) continue;
                objects.add(obj);
            }
        }
        return objects;
    }

    public static File getTestSuiteFile(File bqTestProjectFolder, String queryIdentifier, String testProjectName) {
        String pck = BQTestHelpers.getQueryClassification(queryIdentifier, '/');
        String relativePath = "testSuite/" + testProjectName + "/" + pck + "/" + queryIdentifier + "." + "testSuite";
        return new File(String.valueOf(bqTestProjectFolder.toString()) + "/" + relativePath);
    }

    public static String getPackagePath(IProject bqTestProject, String queryIdentifier, String testProjectName) {
        String pck = BQTestHelpers.getQueryClassification(queryIdentifier, '/');
        String path = bqTestProject.getName().replaceAll("\\.", "/");
        return NLS.bind((String)"{0}/testcases/{1}/{2}", (Object[])new String[]{path, testProjectName, pck});
    }

    public static String getPackageName(IProject bqTestProject, String queryIdentifier, String testProjectName) {
        return BQTestHelpers.getPackagePath(bqTestProject, queryIdentifier, testProjectName).replaceAll("/", ".");
    }

    public static File getJUnitFile(IProject bqTestProject, String queryIdentifier, String testProjectName, String fileName) {
        File bqTestProjectFolder = IResourceHelpers.convertToFile((IResource)bqTestProject);
        String packageName = BQTestHelpers.getPackageName(bqTestProject, queryIdentifier, testProjectName).replaceAll("\\.", "/");
        String junitFileName = String.valueOf(bqTestProjectFolder.toString()) + "/" + "src-gen/" + "/" + packageName + "/" + fileName;
        File junitFile = new File(junitFileName);
        return junitFile;
    }
}

