/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.business.queries.ju;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.shared.id.handler.IdManager;

public class QueryResult {
    private static final String EXCEPTION_KEYWORD = "EXCEPTION";
    private static final String MULTIPLE_COMMENTS_BEGIN_KEYWORD = "/*";
    private static final String MULTIPLE_COMMENTS_END_KEYWORD = "*/";
    private static final String SINGLE_COMMENTS_KEYWORD = "//";
    protected String queryIdentifier;
    protected String inputId;
    protected List<String> resultIds;

    protected QueryResult() {
        this.resultIds = new ArrayList<String>();
    }

    public QueryResult(String queryIdentifier_p, String inputId_p, List<String> resultIds_p) {
        this.queryIdentifier = queryIdentifier_p;
        this.inputId = inputId_p;
        this.resultIds = resultIds_p;
    }

    public String getQueryIdentifier() {
        return this.queryIdentifier;
    }

    public String getInputId() {
        return this.inputId;
    }

    public List<String> getResultIds() {
        return this.resultIds;
    }

    public static QueryResult createQueryResult(String queryIdentifier_p, EObject input, List<? extends EObject> elements) {
        String inputId = QueryResult.getObjectId(input);
        if (inputId == null) {
            return null;
        }
        ArrayList<String> ids = null;
        if (elements != null) {
            ids = new ArrayList<String>();
            for (EObject eObject : elements) {
                String id = QueryResult.getObjectId(eObject);
                if (id == null) {
                    ids = null;
                    return null;
                }
                ids.add(id);
            }
        }
        QueryResult queryResult = new QueryResult(queryIdentifier_p, inputId, ids);
        return queryResult;
    }

    public static String getObjectId(EObject object) {
        return IdManager.getInstance().getId(object);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("queryIdentifier = " + this.queryIdentifier + '\n');
        b.append("inputId = " + this.inputId + '\n');
        if (this.resultIds != null) {
            b.append("resultIds = {\n");
            int i = 0;
            while (i < this.resultIds.size()) {
                b.append("    " + this.resultIds.get(i) + '\n');
                ++i;
            }
            b.append("}\n");
        } else {
            b.append("EXCEPTION\n");
        }
        return b.toString();
    }

    public static List<QueryResult> deserialize(String serializedData) {
        List<String> lines = Arrays.asList(serializedData.split("\r\n|\r|\n"));
        lines = new ArrayList<String>(lines);
        ArrayList<QueryResult> queryResults = new ArrayList<QueryResult>();
        while (lines.size() > 0) {
            QueryResult queryResult = QueryResult.parseOneQueryResult(lines);
            if (queryResult == null) continue;
            queryResults.add(queryResult);
        }
        return queryResults;
    }

    public static String serialize(List<QueryResult> queryResults) {
        StringBuilder buffer = new StringBuilder();
        for (QueryResult queryResult : queryResults) {
            buffer.append(String.valueOf(queryResult.toString()) + '\n');
        }
        return buffer.toString();
    }

    private static void cleanStringList(List<String> lines) {
        while (lines.size() > 0 && StringUtils.trim((String)lines.get(0)).length() == 0) {
            lines.remove(0);
        }
    }

    private static QueryResult parseOneQueryResult(List<String> lines) {
        QueryResult.cleanStringList(lines);
        if (lines.size() > 0) {
            QueryResult current = new QueryResult();
            State state = State.IDLE;
            while (lines.size() > 0 && state != State.END) {
                String line = lines.get(0);
                switch (state) {
                    case IDLE: {
                        if (line.startsWith("queryIdentifier")) {
                            current.queryIdentifier = StringUtils.trim((String)StringUtils.split((String)line, (String)"=")[1]);
                        } else if (line.startsWith("inputId")) {
                            current.inputId = StringUtils.trim((String)StringUtils.split((String)line, (String)"=")[1]);
                        } else if (line.startsWith("resultIds")) {
                            state = State.RESULT_ID;
                        } else if (line.startsWith(EXCEPTION_KEYWORD)) {
                            current.resultIds = null;
                            state = State.CLEAN;
                        }
                        lines.remove(0);
                        break;
                    }
                    case RESULT_ID: {
                        if (StringUtils.trim((String)line).startsWith("}")) {
                            state = State.CLEAN;
                        } else {
                            current.resultIds.add(StringUtils.trim((String)line));
                        }
                        lines.remove(0);
                        break;
                    }
                    case CLEAN: {
                        if (StringUtils.trim((String)line).length() > 0) {
                            state = State.END;
                            break;
                        }
                        lines.remove(0);
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
            return current;
        }
        return null;
    }

    public boolean equals(QueryResult queryResult) {
        return queryResult.queryIdentifier.equals(this.queryIdentifier) && queryResult.inputId.equals(this.inputId) && (queryResult.resultIds == null && this.resultIds == null || queryResult.resultIds != null && this.resultIds != null && new LinkedHashSet<String>(queryResult.resultIds).equals(new LinkedHashSet<String>(this.resultIds)));
    }

    public static enum State {
        IDLE,
        RESULT_ID,
        CLEAN,
        END;

    }
}

