/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.api;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestResult;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public abstract class AbstractDiagramTestCase
extends BasicTestCase {
    public void run(TestResult result) {
        DiagramHelper.setPrefereneRefreshOnOpening(false);
        DiagramHelper.setPreferenceAutoRefresh(false);
        super.run(result);
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.getRequiredTestModel());
    }

    protected void hideDiagramElement(final DDiagramElement diagramElement) {
        Session sessionForTestModel = this.getSessionForTestModel(this.getRequiredTestModel());
        ExecutionManager executionManager = TransactionHelper.getExecutionManager((Session)sessionForTestModel);
        executionManager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                DiagramServices.getDiagramServices().hide(diagramElement);
            }
        });
    }

    protected abstract String getRequiredTestModel();
}

