/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.MissionDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class CapabilityDiagram
extends CommonDiagram {
    BlockArchitectureExt.Type type = null;

    public CapabilityDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(context, diagram);
        this.type = type;
    }

    public static CapabilityDiagram createDiagram(SessionContext executionContext, String targetIdentifier, String name) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        if ("Missions Capabilities Blank".equals(name) || "Missions Blank".equals(name) || "Contextual Capability".equals(name) || "Contextual Mission".equals(name)) {
            return MissionDiagram.createDiagram(executionContext, targetIdentifier, name);
        }
        return (CapabilityDiagram)((DiagramContext)((Object)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new CapabilityDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run())).open();
    }

    public void createActor(String id) {
        this.createActor(id, this.getDiagramId());
    }

    public void createActor(String id, String containerId) {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "Operational Actor";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "Operational Actor";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "Actor";
        } else if (this.isA("Missions Blank")) {
            name = "Actor";
        } else if (this.isA("Contextual Capability")) {
            name = "Actor";
        } else if (this.isA("Contextual Mission")) {
            name = "Actor";
        } else if (this.isA("Capability Realization Blank")) {
            name = "CRB Actor";
        }
        new CreateAbstractDNodeTool((DiagramContext)this, name, containerId, id).run();
    }

    public void createComponent(String id) {
        this.createComponent(id, this.getDiagramId());
    }

    public void createComponent(String id, String containerId) {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "Operational Entity";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "Operational Entity";
        } else if (!(this.isA("Missions Capabilities Blank") || this.isA("Missions Blank") || this.isA("Contextual Capability") || this.isA("Contextual Mission") || !this.isA("Capability Realization Blank"))) {
            name = "Component";
            if (this.type == BlockArchitectureExt.Type.EPBS) {
                name = "COTS";
            }
        }
        new CreateAbstractDNodeTool((DiagramContext)this, name, containerId, id).run();
    }

    public void createCapability(String id) {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "Operational Capability";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "Operational Capability";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "Capability";
        } else if (this.isA("Missions Blank")) {
            name = "Capability";
        } else if (this.isA("Contextual Capability")) {
            name = "Capability";
        } else if (this.isA("Contextual Mission")) {
            name = "Capability";
        } else if (this.isA("Capability Realization Blank")) {
            name = "Capability Realization ";
        }
        new CreateAbstractDNodeTool((DiagramContext)this, name, this.getDiagramId(), id).run();
    }

    public void createActorGeneralization(String sourceId, String targetId) {
        this.createActorGeneralization(sourceId, targetId, null);
    }

    public void createActorGeneralization(String sourceId, String targetId, String id) {
        String name = null;
        if (!this.isA("Contextual Operational Capability") && !this.isA("Operational Capabilities Blank")) {
            if (this.isA("Missions Capabilities Blank")) {
                name = "Actor Generalization";
            } else if (this.isA("Missions Blank")) {
                name = "Actor Generalization";
            } else if (this.isA("Contextual Capability")) {
                name = "Actor Generalization";
            } else if (this.isA("Contextual Mission")) {
                name = "Actor Generalization";
            } else if (this.isA("Capability Realization Blank")) {
                name = "Actor Generalization";
            }
        }
        new CreateDEdgeTool(this, name, sourceId, targetId, id).run();
    }

    public void createCapabilityGeneralization(String sourceId, String targetId) {
        this.createCapabilityGeneralization(sourceId, targetId, null);
    }

    public void createCapabilityGeneralization(String sourceId, String targetId, String id) {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "Operational Capability Generalization";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "Operational Capability Generalization";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "Capability Generalization";
        } else if (!this.isA("Missions Blank")) {
            if (this.isA("Contextual Capability")) {
                name = "Capability Generalization";
            } else if (!this.isA("Contextual Mission") && this.isA("Capability Realization Blank")) {
                name = "Capability Generalization";
            }
        }
        new CreateDEdgeTool(this, name, sourceId, targetId, id).run();
    }

    public void createCapabilityInvolvement(String sourceId, String targetId) {
        this.createCapabilityInvolvement(sourceId, targetId, null);
    }

    public void createCapabilityInvolvement(String sourceId, String targetId, String id) {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "Involvement";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "Involvement";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "Involved Actor";
        } else if (this.isA("Missions Blank")) {
            name = "Actor Involvement";
        } else if (this.isA("Contextual Capability")) {
            name = "Involved Actor";
        } else if (this.isA("Contextual Mission")) {
            name = "Actor Involvement";
        } else if (this.isA("Capability Realization Blank")) {
            name = "Involvement";
        }
        new CreateDEdgeTool(this, name, sourceId, targetId, id).run();
    }

    public void createCapabilityExtends(String sourceId, String targetId) {
        this.createCapabilityExtends(sourceId, targetId, null);
    }

    public void createCapabilityExtends(String sourceId, String targetId, String id) {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "Extends";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "Extends";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "Extends";
        } else if (!this.isA("Missions Blank")) {
            if (this.isA("Contextual Capability")) {
                name = "Extends";
            } else if (!this.isA("Contextual Mission") && this.isA("Capability Realization Blank")) {
                name = "Extends";
            }
        }
        new CreateDEdgeTool(this, name, sourceId, targetId, id).run();
    }

    public void createCapabilityIncludes(String sourceId, String targetId) {
        this.createCapabilityIncludes(sourceId, targetId, null);
    }

    public void createCapabilityIncludes(String sourceId, String targetId, String id) {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "Includes";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "Includes";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "Includes";
        } else if (!this.isA("Missions Blank")) {
            if (this.isA("Contextual Capability")) {
                name = "Includes";
            } else if (!this.isA("Contextual Mission") && this.isA("Capability Realization Blank")) {
                name = "Includes";
            }
        }
        new CreateDEdgeTool(this, name, sourceId, targetId, id).run();
    }

    public void createComponentExchange(String sourceId, String targetId) {
        this.createComponentExchange(sourceId, targetId, null);
    }

    public void createComponentExchange(String sourceId, String targetId, String id) {
        String name = null;
        if (!this.isA("Contextual Operational Capability")) {
            if (this.isA("Operational Capabilities Blank")) {
                name = "CommunicationMean";
            } else if (!(this.isA("Missions Capabilities Blank") || this.isA("Missions Blank") || this.isA("Contextual Capability") || this.isA("Contextual Mission"))) {
                this.isA("Capability Realization Blank");
            }
        }
        new CreateDEdgeTool(this, name, sourceId, targetId, id).run();
    }

    public void insertActor(String id) {
        this.insertActor(id, this.getDiagramId());
    }

    public void insertActor(String id, String containerId) {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "Operational Actors";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "Operational Actors";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "s/h Actors";
        } else if (this.isA("Missions Blank")) {
            name = "Actors";
        } else if (this.isA("Contextual Capability")) {
            name = "Actors";
        } else if (this.isA("Contextual Mission")) {
            name = "s/h Actors";
        } else if (this.isA("Capability Realization Blank")) {
            name = "Actors";
        }
        new InsertRemoveTool((DiagramContext)this, name, containerId).insert(id);
    }

    public void removeActor(String id) {
        this.removeActor(id, this.getDiagramId());
    }

    public void removeActor(String id, String containerId) {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "Operational Actors";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "Operational Actors";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "s/h Actors";
        } else if (this.isA("Missions Blank")) {
            name = "Actors";
        } else if (this.isA("Contextual Capability")) {
            name = "Actors";
        } else if (this.isA("Contextual Mission")) {
            name = "s/h Actors";
        } else if (this.isA("Capability Realization Blank")) {
            name = "Actors";
        }
        new InsertRemoveTool((DiagramContext)this, name, containerId).remove(id);
    }

    public void insertComponent(String id) {
        this.insertComponent(id, this.getDiagramId());
    }

    public void insertComponent(String id, String containerId) {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "Operational Entities";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "Operational Entities";
        } else if (!(this.isA("Missions Capabilities Blank") || this.isA("Missions Blank") || this.isA("Contextual Capability") || this.isA("Contextual Mission") || !this.isA("Capability Realization Blank"))) {
            name = "Components";
        }
        new InsertRemoveTool((DiagramContext)this, name, containerId).insert(id);
    }

    public void removeComponent(String id) {
        this.removeComponent(id, this.getDiagramId());
    }

    public void removeComponent(String id, String containerId) {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "Operational Entities";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "Operational Entities";
        } else if (!(this.isA("Missions Capabilities Blank") || this.isA("Missions Blank") || this.isA("Contextual Capability") || this.isA("Contextual Mission") || !this.isA("Capability Realization Blank"))) {
            name = "Components";
        }
        new InsertRemoveTool((DiagramContext)this, name, containerId).remove(id);
    }

    public void insertCapability(String ... id) {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "Operational Capabilities";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "Operational Capabilities";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "s/h Capabilities";
        } else if (this.isA("Missions Blank")) {
            name = "Capabilities";
        } else if (this.isA("Contextual Capability")) {
            name = "Capabilities";
        } else if (this.isA("Contextual Mission")) {
            name = "s/h Capabilities";
        } else if (this.isA("Capability Realization Blank")) {
            name = "Capability Realizations";
        }
        new InsertRemoveTool((DiagramContext)this, name, this.getDiagramId()).insert(id);
    }

    public void removeCapability(String ... id) {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "Operational Capabilities";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "Operational Capabilities";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "s/h Capabilities";
        } else if (this.isA("Missions Blank")) {
            name = "Capabilities";
        } else if (this.isA("Contextual Capability")) {
            name = "Capabilities";
        } else if (this.isA("Contextual Mission")) {
            name = "s/h Capabilities";
        } else if (this.isA("Capability Realization Blank")) {
            name = "Capability Realizations";
        }
        new InsertRemoveTool((DiagramContext)this, name, this.getDiagramId()).remove(id);
    }

    public void insertRelationship(String id) {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "Relationships";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "Relationships";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "Show/Hide Relationships";
        } else if (this.isA("Missions Blank")) {
            name = "Relationships";
        } else if (this.isA("Contextual Capability")) {
            name = "Relationships";
        } else if (this.isA("Contextual Mission")) {
            name = "Relationships";
        } else if (this.isA("Capability Realization Blank")) {
            name = "Relationships";
        }
        new InsertRemoveTool((DiagramContext)this, name, this.getDiagramId()).insert(id);
    }

    public void insertAllRelationships(String containerId) {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "Relationships";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "Relationships";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "Show/Hide Relationships";
        } else if (this.isA("Missions Blank")) {
            name = "Relationships";
        } else if (this.isA("Contextual Capability")) {
            name = "Relationships";
        } else if (this.isA("Contextual Mission")) {
            name = "Relationships";
        } else if (this.isA("Capability Realization Blank")) {
            name = "Relationships";
        }
        new InsertRemoveTool((DiagramContext)this, name, containerId).insertAll();
    }
}

