/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.diagram.helpers.DiagramHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.test.diagram.common.ju.step.crud.ClearDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.RefreshDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.SetContextualElementsStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.framework.api.CommonTestMessages;
import org.polarsys.capella.test.framework.context.SessionContext;

public class DiagramContext
extends SessionContext {
    protected DDiagram _diagram;
    protected SessionContext _sessionContext;
    protected String diagramIdentifier;
    private Map<String, DDiagramElement> _viewObjectMap;
    private String _type;

    public static DiagramContext getDiagram(SessionContext executionContext, String targetIdentifier) {
        DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((ResourceSet)executionContext.getSession().getTransactionalEditingDomain().getResourceSet(), (String)targetIdentifier);
        return new DiagramContext(executionContext, (DDiagram)descriptor.getRepresentation());
    }

    public Map<String, DDiagramElement> getViewObjectMap() {
        if (this._viewObjectMap == null) {
            this._viewObjectMap = new HashMap<String, DDiagramElement>();
        }
        return this._viewObjectMap;
    }

    public DiagramContext(SessionContext context, DDiagram diagram) {
        super(DiagramHelper.getService().getSession((DRepresentation)diagram));
        this.diagramIdentifier = diagram.getName();
        this._diagram = diagram;
        this._type = this._diagram.getDescription().getName();
        this._sessionContext = context;
    }

    public String getType() {
        return this._type;
    }

    public Map<String, EObject> getSemanticObjectMap() {
        return this._sessionContext.getSemanticObjectMap();
    }

    public DDiagram getDiagram() {
        return this._diagram;
    }

    public DRepresentationDescriptor getDiagramDescriptor() {
        return RepresentationHelper.getRepresentationDescriptor((DRepresentation)this._diagram);
    }

    public String getDiagramId() {
        return this.diagramIdentifier;
    }

    protected boolean isA(String diagramDescription) {
        return DiagramHelper.getService().isA((DRepresentation)this._diagram, diagramDescription);
    }

    public DSemanticDecorator getView(String semanticIdentifier) {
        if (this.getDiagramId().equals(semanticIdentifier)) {
            return (DSemanticDiagram)this._diagram;
        }
        DSemanticDecorator view = null;
        if (this.getViewObjectMap().containsKey(semanticIdentifier)) {
            view = (DSemanticDecorator)this.getViewObjectMap().get(semanticIdentifier);
            if (DiagramHelper.getService().getDiagramContainer((EObject)view) == null) {
                this.getViewObjectMap().remove(semanticIdentifier);
                view = null;
            }
        }
        if (view == null && (view = this.getView(this.getSemanticElement(semanticIdentifier))) instanceof DDiagramElement) {
            this.putView(semanticIdentifier, (DDiagramElement)view);
        }
        return view;
    }

    public DDiagramElement getView(EObject semantic) {
        return org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper.getOnDiagram(this._diagram, semantic);
    }

    public DDiagramElement getView(String semanticIdentifier, DSemanticDecorator view) {
        EObject semantic = this.getSemanticElement(semanticIdentifier);
        return org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper.getOnDiagram(this._diagram, semantic, (EObject)view);
    }

    protected EObject adaptToView(EObject semantic) {
        return semantic;
    }

    public void putView(String newIdentifier, DDiagramElement view) {
        this.getViewObjectMap().put(newIdentifier, view);
    }

    public void hasView(String identifier) {
        this.hasView(identifier, null);
    }

    public void hasView(String identifier, String mappingName) {
        EObject eObject = this.getSemanticElement(identifier);
        DSemanticDecorator view = this.getView(identifier);
        boolean result = view != null;
        Assert.assertTrue((String)NLS.bind((String)CommonTestMessages.objectRepresentationNotAvailableOnDiagram, (Object)EObjectLabelProviderHelper.getText((EObject)eObject)), (boolean)result);
        if (mappingName != null) {
            AbstractNodeMapping mapping = DiagramServices.getDiagramServices().getAbstractNodeMapping(this.getDiagram().getDescription(), mappingName);
            Assert.assertTrue((String)NLS.bind((String)CommonTestMessages.wrongMapping, (Object)mappingName), (boolean)DiagramServices.getDiagramServices().isMapping((DDiagramElement)view, (DiagramElementMapping)mapping));
        }
    }

    public void hasntView(String identifier) {
        EObject eObject = this.getSemanticElement(identifier);
        boolean result = this.getView(identifier) == null;
        Assert.assertTrue((String)NLS.bind((String)CommonTestMessages.objectRepresentationStillAvailableOnDiagram, (Object)EObjectLabelProviderHelper.getText((EObject)eObject)), (boolean)result);
    }

    public void hasHiddenView(String identifier) {
        EObject eObject = this.getSemanticElement(identifier);
        DSemanticDecorator view = this.getView(identifier);
        if (view == null) {
            Assert.assertTrue((String)"view is null", (boolean)false);
        } else if (view instanceof DDiagramElement) {
            boolean result = DiagramServices.getDiagramServices().isHidden((DDiagramElement)view);
            Assert.assertTrue((String)NLS.bind((String)CommonTestMessages.objectRepresentationStillAvailableOnDiagram, (Object)EObjectLabelProviderHelper.getText((EObject)eObject)), (boolean)result);
        } else {
            Assert.assertTrue((String)"view is diagram", (boolean)false);
        }
    }

    public void hasFilteredView(String identifier) {
        EObject eObject = this.getSemanticElement(identifier);
        DSemanticDecorator view = this.getView(identifier);
        if (view == null) {
            Assert.assertTrue((String)"view is null", (boolean)false);
        } else if (view instanceof DDiagramElement) {
            boolean result = DiagramServices.getDiagramServices().isFiltered((DDiagramElement)view);
            Assert.assertTrue((String)NLS.bind((String)CommonTestMessages.objectRepresentationStillAvailableOnDiagram, (Object)EObjectLabelProviderHelper.getText((EObject)eObject)), (boolean)result);
        } else {
            Assert.assertTrue((String)"view is diagram", (boolean)false);
        }
    }

    public DiagramContext open() {
        new OpenDiagramStep(this).run();
        return this;
    }

    public void refreshDiagram() {
        new RefreshDiagramStep(this).run();
    }

    public void clearDiagram() {
        new ClearDiagramStep(this).run();
    }

    public void mustBeInstanceOf(String objectId, EClass clazz) {
        Assert.assertTrue((boolean)clazz.isInstance((Object)this.getSemanticElement(objectId)));
    }

    public void mustBeLinkedTo(String objectId, String valueId, EStructuralFeature feature) {
        EObject object = this.getSemanticElement(objectId);
        EObject value = this.getSemanticElement(valueId);
        if (feature.isMany()) {
            Assert.assertTrue((boolean)((EList)object.eGet(feature)).contains((Object)value));
        } else {
            Assert.assertTrue((boolean)object.eGet(feature).equals(value));
        }
    }

    public void hasCountViews(int i) {
        Assert.assertTrue((this.getDiagram().getDiagramElements().size() == i ? 1 : 0) != 0);
    }

    public void mustBeOwnedBy(String objectId, String containerId) {
        EObject object = this.getSemanticElement(objectId);
        EObject container = this.getSemanticElement(containerId);
        Assert.assertTrue((boolean)object.eContainer().equals(container));
    }

    public void mustGraphicalOwnedBy(String objectId, String containerId) {
        Assert.assertTrue((boolean)this.getView(objectId).eContainer().equals(this.getView(containerId)));
    }

    public void setContextualElements(String ... ids) {
        new SetContextualElementsStep(this, ids).run();
    }

    public Collection<EObject> adaptTool(AbstractToolStep tool, Map<String, Object> parameters, Collection<EObject> semanticElements) {
        return semanticElements;
    }
}

