/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.PA_ESDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.SA_ESDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.sequence.MessageCreationTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.sequence.TimerCreationTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class ESDiagram
extends DiagramContext {
    BlockArchitectureExt.Type type = null;

    public ESDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(context, diagram);
        this.type = type;
    }

    public static ESDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        String name = null;
        name = type == BlockArchitectureExt.Type.OA ? "Operational Interaction Scenario" : "Component Exchanges Scenario";
        if (type == BlockArchitectureExt.Type.SA) {
            return (SA_ESDiagram)((DiagramContext)((Object)new CreateDiagramStep(executionContext, targetIdentifier, name){

                @Override
                public DiagramContext getResult() {
                    return new SA_ESDiagram(type, this.getExecutionContext(), this.diagram);
                }
            }.run())).open();
        }
        if (type == BlockArchitectureExt.Type.PA) {
            return (PA_ESDiagram)((DiagramContext)((Object)new CreateDiagramStep(executionContext, targetIdentifier, name){

                @Override
                public DiagramContext getResult() {
                    return new PA_ESDiagram(type, this.getExecutionContext(), this.diagram);
                }
            }.run())).open();
        }
        return (ESDiagram)((DiagramContext)((Object)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new ESDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run())).open();
    }

    public static ESDiagram openDiagram(SessionContext executionContext, String name, final BlockArchitectureExt.Type type) {
        return (ESDiagram)((DiagramContext)((Object)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new ESDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run())).open();
    }

    public void createActor(String id) {
        String name = null;
        name = this.type == BlockArchitectureExt.Type.OA ? "Operational Actor" : "Actor";
        new CreateNodeTool((DiagramContext)this, name, this.getDiagramId(), id).run();
    }

    public void insertActor(String id) {
        String name = null;
        name = this.type == BlockArchitectureExt.Type.OA ? "Operational Entities / roles" : "Actors";
        new InsertRemoveTool((DiagramContext)this, name).insert(id);
    }

    public void removeActor(String id) {
        String name = null;
        name = this.type == BlockArchitectureExt.Type.OA ? "Operational Entities / roles" : "Actors";
        new InsertRemoveTool((DiagramContext)this, name).remove(id);
    }

    public void createComponent(String id) {
        String name = null;
        name = this.type == BlockArchitectureExt.Type.OA ? "Operational Entity" : "Component";
        new CreateNodeTool((DiagramContext)this, name, this.getDiagramId(), id).run();
    }

    public void insertComponent(String id) {
        String name = null;
        name = this.type == BlockArchitectureExt.Type.OA ? "Operational Entities / roles" : "Components";
        new InsertRemoveTool((DiagramContext)this, name).insert(id);
    }

    public void removeComponent(String id) {
        String name = null;
        name = this.type == BlockArchitectureExt.Type.OA ? "Operational Entities / roles" : "Components";
        new InsertRemoveTool((DiagramContext)this, name).remove(id);
    }

    public void createFunctionalExchange(String functionalExchange, String source, String target) {
        String name = "Functional Exchange";
        new MessageCreationTool(this, name, functionalExchange, source, target).run();
    }

    public void createArmTimer(String source, String target) {
        String name = "Arm timer";
        new TimerCreationTool(this, name, source, target).run();
    }

    @Override
    public Collection<EObject> adaptTool(AbstractToolStep tool, Map<String, Object> parameters, Collection<EObject> semanticElements) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject element : semanticElements) {
            if (element instanceof InstanceRole) {
                result.add((EObject)((InstanceRole)element).getRepresentedInstance());
                continue;
            }
            result.add(element);
        }
        return result;
    }
}

