/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import java.util.Arrays;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class IDBDiagram
extends DiagramContext {
    String type = null;

    public IDBDiagram(SessionContext context, DDiagram diagram) {
        super(context, diagram);
    }

    public static IDBDiagram createDiagram(SessionContext executionContext, String diagramKind, String targetIdentifier) {
        if (!Arrays.asList("Interfaces Diagram Blank", "Contextual Component Detailed Interfaces", "Contextual Component External Interfaces", "Contextual Component Internal Interfaces").contains(diagramKind)) {
            throw new RuntimeException("this diagram is not compatible with IDBDiagram API");
        }
        return (IDBDiagram)((DiagramContext)((Object)new CreateDiagramStep(executionContext, targetIdentifier, diagramKind){

            @Override
            public DiagramContext getResult() {
                return new IDBDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run())).open();
    }

    public static IDBDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        return IDBDiagram.createDiagram(executionContext, "Interfaces Diagram Blank", targetIdentifier);
    }

    public void createActor(String id) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Actor";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "Actor";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
        }
        new CreateContainerTool((DiagramContext)this, toolName, this.getDiagramId(), id).run();
    }

    public void createComponent(String idContainer, String id) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Component";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "Component";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                toolName = "Component";
            }
        }
        new CreateContainerTool((DiagramContext)this, toolName, idContainer, id).run();
    }

    public void createComponent(String id) {
        this.createComponent(this.getDiagramId(), id);
    }

    public void createEvent(String idContainer, String id) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Event";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "Event";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "Event";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "Event";
        }
        new CreateContainerTool((DiagramContext)this, toolName, idContainer, id).run();
    }

    public void createEvent(String id) {
        this.createEvent(this.getDiagramId(), id);
    }

    public String getToolInsertComponents() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Show/Hide Components";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "Components";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                toolName = "Components";
            }
        }
        return toolName;
    }

    public String getToolInsertRelationship() {
        String toolName = null;
        if (!"Interfaces Diagram Blank".equals(this.getType())) {
            throw new UnsupportedOperationException();
        }
        toolName = "Show/Hide Relationships";
        return toolName;
    }

    public void insertComponents(String ... id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolInsertComponents()).insert(id);
    }

    public void removeComponent(String ... id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolInsertComponents()).remove(id);
    }

    public void insertRelationship(String container, String ... id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolInsertRelationship(), container).insert(id);
    }

    public void removeRelationship(String container, String ... id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolInsertRelationship(), container).remove(id);
    }

    public void createCommunicationLinkAcquire(String idSource, String idTarget, String id) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "CommunicationLink Receive / Consume / Execute / Access / Acquire";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "Acquire";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "Acquire";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "Acquire";
        }
        new CreateDEdgeTool(this, toolName, idSource, idTarget, id).run();
    }

    public void createCommunicationLinkTransmit(String idSource, String idTarget, String id) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Transmit";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "Transmit";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "Transmit";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "Transmit";
        }
        new CreateDEdgeTool(this, toolName, idSource, idTarget, id).run();
    }

    public void createStandardPort(String idContainer, String id) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Standard Port";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "Standard Port";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "Standard Port";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "Standard Port";
        }
        new CreateNodeTool((DiagramContext)this, toolName, idContainer, id).run();
    }

    public void createInterface(String id) {
        this.createInterface(this.getDiagramId(), id);
    }

    public void createInterface(String idContainer, String id) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Interface";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "Interface";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "Interface";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "Interface";
        }
        new CreateContainerTool((DiagramContext)this, toolName, idContainer, id).run();
    }

    public void createGeneralization(String idTarget, String idSource) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Generalization";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "Generalization";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "Generalization";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "Generalization";
        }
        new CreateDEdgeTool(this, toolName, idSource, idTarget).run();
    }

    public void createGeneralization(String idSource, String idTarget, String id) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Generalization";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "Generalization";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "Generalization";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "Generalization";
        }
        new CreateDEdgeTool(this, toolName, idSource, idTarget, id).run();
    }

    public void createGeneralizationNotEnabled(String idSource, String idTarget) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Generalization";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "Generalization";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "Generalization";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "Generalization";
        }
        new CreateDEdgeTool(this, toolName, idSource, idTarget).cannotRun();
    }

    public void createImplements(String idSource, String idTarget, String id) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Implements";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "Implements";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "Implements";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "Implements";
        }
        new CreateDEdgeTool(this, toolName, idSource, idTarget, id).run();
    }

    public void createImplementsNotEnabled(String idSource, String idTarget) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Implements";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "Implements";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "Implements";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "Implements";
        }
        new CreateDEdgeTool(this, toolName, idSource, idTarget).cannotRun();
    }

    public void createProvides(String idSource, String idTarget, String id, String idNewSource) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Provides";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "Provides";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "Provides";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "Provides";
        }
        new CreateDEdgeTool(this, toolName, idSource, idTarget, id, idNewSource, null).run();
    }

    public void createProvidesNotEnabled(String idSource, String idTarget) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Provides";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "Provides";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "Provides";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "Provides";
        }
        new CreateDEdgeTool(this, toolName, idSource, idTarget).cannotRun();
    }

    public void createRequiresNotEnabled(String idSource, String idTarget) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Requires";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "Requires";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "Requires";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "Requires";
        }
        new CreateDEdgeTool(this, toolName, idSource, idTarget).cannotRun();
    }

    public void createRequires(String idSource, String idTarget, String id, String idNewSource) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Requires";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "Requires";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "Requires";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "Requires";
        }
        new CreateDEdgeTool(this, toolName, idSource, idTarget, id, idNewSource, null).run();
    }

    public void createUses(String idSource, String idTarget, String id) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Uses";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "Uses";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "Uses";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "Uses";
        }
        new CreateDEdgeTool(this, toolName, idSource, idTarget, id).run();
    }

    public void createUsesNotEnabled(String idSource, String idTarget, String id) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "Uses";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "Uses";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "Uses";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "Uses";
        }
        new CreateDEdgeTool(this, toolName, idSource, idTarget, id).cannotRun();
    }
}

