/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.SetUnsynchronizedStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class MSMDiagram
extends DiagramContext {
    BlockArchitectureExt.Type type = null;

    public MSMDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(context, diagram);
        this.type = type;
    }

    public static void setSynchronized(MSMDiagram diagram) {
        new SetUnsynchronizedStep(diagram, true).run();
    }

    public static void setUnsynchronized(MSMDiagram diagram) {
        new SetUnsynchronizedStep(diagram).run();
    }

    public static MSMDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        String name = "Mode State Machine";
        return (MSMDiagram)((DiagramContext)((Object)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new MSMDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run())).open();
    }

    public static MSMDiagram openDiagram(SessionContext executionContext, String name, final BlockArchitectureExt.Type type) {
        return (MSMDiagram)((DiagramContext)((Object)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new MSMDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run())).open();
    }

    public void createMode(String idContainer, String id) {
        new CreateContainerTool((DiagramContext)this, "Mode", idContainer, id).run();
    }

    public void createState(String idContainer, String id) {
        new CreateContainerTool((DiagramContext)this, "State", idContainer, id).run();
    }

    public void createRegion(String idContainer, String id) {
        new CreateContainerTool((DiagramContext)this, "Region", idContainer, id).run();
    }

    public void createChoice(String idContainer, String id) {
        new CreateNodeTool((DiagramContext)this, "Choice", idContainer, id).run();
    }

    public void createFinal(String idContainer, String id) {
        new CreateNodeTool((DiagramContext)this, "Final", idContainer, id).run();
    }

    public void createFork(String idContainer, String id) {
        new CreateNodeTool((DiagramContext)this, "Fork", idContainer, id).run();
    }

    public void createInitial(String idContainer, String id) {
        new CreateNodeTool((DiagramContext)this, "Initial", idContainer, id).run();
    }

    public void createJoin(String idContainer, String id) {
        new CreateNodeTool((DiagramContext)this, "Join", idContainer, id).run();
    }

    public void createTerminate(String idContainer, String id) {
        new CreateNodeTool((DiagramContext)this, "Terminate", idContainer, id).run();
    }

    public void createDeepHistory(String idContainer, String id) {
        new CreateNodeTool((DiagramContext)this, "DeepHistory", idContainer, id).run();
    }

    public void createShallowHistory(String idContainer, String id) {
        new CreateNodeTool((DiagramContext)this, "ShallowHistory", idContainer, id).run();
    }

    public void createEntryPoint(String idTargetContainer, String idContainer, String id) {
        new CreateNodeTool((DiagramContext)this, "EntryPoint", idTargetContainer, idContainer, id).run();
    }

    public void createExitPoint(String idTargetContainer, String idContainer, String id) {
        new CreateNodeTool((DiagramContext)this, "ExitPoint", idTargetContainer, idContainer, id).run();
    }

    public void createTransition(String idSource, String idTarget, String id) {
        new CreateDEdgeTool(this, "Transition", idSource, idTarget, id).run();
    }

    public void insertReuseModeState(String containerId, String id) {
        new InsertRemoveTool((DiagramContext)this, "Reuse Mode/State", containerId).insert(id);
    }

    public void removeReuseModeState(String containerId, String id) {
        new InsertRemoveTool((DiagramContext)this, "Reuse Mode/State", containerId).remove(id);
    }

    public void showStateMode(String containerId, String id) {
        new InsertRemoveTool((DiagramContext)this, "ShowHide ModeState", containerId).insert(id);
    }

    public void hideStateMode(String containerId, String id) {
        new InsertRemoveTool((DiagramContext)this, "ShowHide ModeState", containerId).remove(id);
    }

    public void showTransition(String containerId, String id) {
        new InsertRemoveTool((DiagramContext)this, "ShowHide Transition", containerId).insert(id);
    }

    public void hideTransition(String containerId, String id) {
        new InsertRemoveTool((DiagramContext)this, "ShowHide Transition", containerId).remove(id);
    }
}

