/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.CapabilityDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class MissionDiagram
extends CapabilityDiagram {
    public MissionDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(type, context, diagram);
    }

    public static MissionDiagram createDiagram(SessionContext executionContext, String targetIdentifier, String name) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        return (MissionDiagram)((DiagramContext)((Object)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new MissionDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run())).open();
    }

    public void createCapabilityExploitation(String sourceId, String targetId, String id) {
        String name = null;
        if (this.isA("Missions Capabilities Blank")) {
            name = "Capability Exploitation";
        } else if (this.isA("Missions Blank")) {
            name = "Capability Exploitation";
        } else if (this.isA("Contextual Capability")) {
            name = "Capability Exploitation";
        } else if (this.isA("Contextual Mission")) {
            name = "Capability Exploitation";
        }
        new CreateDEdgeTool(this, name, sourceId, targetId, id).run();
    }

    public void createCapabilityExploitation(String sourceId, String targetId) {
        this.createCapabilityExploitation(sourceId, targetId, null);
    }

    public void createMission(String id) {
        String name = null;
        if (this.isA("Missions Capabilities Blank")) {
            name = "Mission";
        } else if (this.isA("Missions Blank")) {
            name = "Mission";
        } else if (this.isA("Contextual Capability")) {
            name = "Mission";
        }
        new CreateAbstractDNodeTool((DiagramContext)this, name, this.getDiagramId(), id).run();
    }

    public void createMissionInvolvement(String sourceId, String targetId) {
        String name = null;
        if (this.isA("Missions Capabilities Blank")) {
            name = "Involved Actor";
        } else if (this.isA("Missions Blank")) {
            name = "Actor Involvement";
        } else if (this.isA("Contextual Mission")) {
            name = "Actor Involvement";
        }
        new CreateDEdgeTool(this, name, sourceId, targetId).run();
    }

    public boolean canInsertMission() {
        if (this.isA("Missions Capabilities Blank")) {
            return true;
        }
        return this.isA("Missions Blank");
    }

    public void insertMission(String id) {
        String name = null;
        if (this.isA("Missions Capabilities Blank")) {
            name = "s/h Missions";
        } else if (this.isA("Missions Blank")) {
            name = "Missions";
        } else if (this.isA("Contextual Capability")) {
            name = "s/h Missions";
        }
        new InsertRemoveTool((DiagramContext)this, name, this.getDiagramId()).insert(id);
    }

    public void removeMission(String id) {
        String name = null;
        if (this.isA("Missions Capabilities Blank")) {
            name = "s/h Missions";
        } else if (this.isA("Missions Blank")) {
            name = "Missions";
        } else if (this.isA("Contextual Capability")) {
            name = "s/h Missions";
        }
        new InsertRemoveTool((DiagramContext)this, name, this.getDiagramId()).remove(id);
    }
}

