/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.analysis.actions.extensions.AbstractExternalJavaAction;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.PABDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreatePathTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class XABDiagram
extends CommonDiagram {
    BlockArchitectureExt.Type type = null;

    public XABDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(context, diagram);
        this.type = type;
    }

    public static XABDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        String name = null;
        if (type == BlockArchitectureExt.Type.OA) {
            name = "Operational Entity Blank";
        } else if (type == BlockArchitectureExt.Type.SA) {
            name = "System Architecture Blank";
        } else if (type == BlockArchitectureExt.Type.LA) {
            name = "Logical Architecture Blank";
        } else if (type == BlockArchitectureExt.Type.PA) {
            name = "Physical Architecture Blank";
        }
        if (type == BlockArchitectureExt.Type.PA) {
            return PABDiagram.createDiagram(executionContext, targetIdentifier);
        }
        return (XABDiagram)((DiagramContext)((Object)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new XABDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run())).open();
    }

    public static XABDiagram openDiagram(SessionContext executionContext, String name, final BlockArchitectureExt.Type type) {
        return (XABDiagram)((DiagramContext)((Object)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new XABDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run())).open();
    }

    public void createActor(String id) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "Operational Actor";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "Actor";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Logical Actor";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "Physical Actor";
        }
        new CreateContainerTool((DiagramContext)this, name, this.getDiagramId(), id).run();
    }

    public void createFunction(String id, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "Operational Activity";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "System Function";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Logical Function";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "Physical Function";
        }
        new CreateNodeTool((DiagramContext)this, name, containerId, id).run();
    }

    public void removeActor(String id) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "Operational Entities";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "Show/Hide Actors";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Show/Hide Actors";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "Show/Hide Actors";
        }
        new InsertRemoveTool((DiagramContext)this, name).remove(id);
    }

    public void removeComponent(String id) {
        this.removeComponent(id, this.getDiagramId());
    }

    public void removeComponent(String id, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "Operational Entities";
            new InsertRemoveTool((DiagramContext)this, name).remove(id);
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            new InsertRemoveTool((DiagramContext)this, new String[]{"Insert/Remove Components mono part", "Components"}, containerId).remove(id);
        }
    }

    public void createComponent(String id, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "Operational Entity";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Logical Component";
        }
        new CreateContainerTool((DiagramContext)this, name, containerId, id).run();
    }

    public void createComponentExchange(String idSource, String idTarget, String id) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "Communication Mean";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "Connection with ports";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Component Exchange";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "Component Exchange";
        }
        new CreateDEdgeTool(this, name, idSource, idTarget, id).run();
    }

    public void createComponentExchangeDelegation(String idSource, String idTarget, String id) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Delegation";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "Delegation";
        }
        new CreateDEdgeTool(this, name, idSource, idTarget, id).run();
    }

    public void createFunctionalExchange(String idSource, String idTarget, String id) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "Interaction";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "Functional Exchange";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Functional Exchange";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "Functional Exchange";
        }
        new CreateDEdgeTool(this, name, idSource, idTarget, id).run();
    }

    public void createPhysicalLink(String idSource, String idTarget, String id) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.SA) {
            name = "Physical Link";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Physical Link";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "Physical Link";
        }
        new CreateDEdgeTool(this, name, idSource, idTarget, id).run();
    }

    public void insertComponentExchange(String id, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "Show/Hide Communication Mean";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "Show/Hide Connections";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Show/Hide Connections";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "Show/Hide ComponentExchanges";
        }
        new InsertRemoveTool((DiagramContext)this, name, containerId).insert(id);
    }

    public void insertComponent(String toInsertId, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "Operational Entities";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Insert/Remove Components mono part";
        }
        new InsertRemoveTool((DiagramContext)this, name, containerId).insert(toInsertId);
    }

    public void insertPhysicalLink(String id, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.SA) {
            name = "Show/Hide Physical Links";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Show/Hide Physical Links";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "Show/Hide Physical Links";
        }
        new InsertRemoveTool((DiagramContext)this, name, containerId).insert(id);
    }

    public void manageAllocatedFunction(String id, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "Manage Activity Allocation";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "Manage Function Allocation";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Manage Function Allocation";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "Manage Function Allocation";
        }
        new InsertRemoveTool((DiagramContext)this, name, containerId).insert(id);
    }

    public void insertAllocatedFunction(String id, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "Allocated Activities";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "Allocated Functions";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Allocated Functions";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "Allocated Functions";
        }
        new InsertRemoveTool((DiagramContext)this, name, containerId).insert(id);
    }

    public void removeAllocatedFunction(String id, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "Allocated Activities";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "Allocated Functions";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Allocated Functions";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "Allocated Functions";
        }
        new InsertRemoveTool((DiagramContext)this, name, containerId).remove(id);
    }

    @Override
    public Collection<EObject> adaptTool(AbstractToolStep tool, Map<String, Object> parameters, Collection<EObject> semanticElements) {
        Collection scope = AbstractExternalJavaAction.getScope(parameters);
        if (scope.isEmpty()) {
            return semanticElements;
        }
        EObject scopeElement = (EObject)scope.iterator().next();
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject element : semanticElements) {
            if (element instanceof Part && scopeElement instanceof Component) {
                result.add((EObject)((Part)element).getAbstractType());
                continue;
            }
            if (element instanceof Component && scopeElement instanceof Part) {
                result.add((EObject)((Component)element).getRepresentingPartitions().get(0));
                continue;
            }
            result.add(element);
        }
        return result;
    }

    public void insertFunctionalExchange(String id, String containerId, boolean autoRefresh) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.SA) {
            name = "Show/Hide Functional Exchanges";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Show/Hide Functional Exchanges";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "Show/Hide Functional Exchanges";
        }
        new InsertRemoveTool(this, name, containerId, autoRefresh).insert(id);
    }

    public void createPhysicalPath(String path, String ... links) {
        new CreatePathTool(this, "Physical Path", path, links).run();
    }

    public void createFunctionalChain(String path, String ... links) {
        new CreatePathTool(this, "Functional Chain", path, links).run();
    }
}

