/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.epbs.ConfigurationItemKind;
import org.polarsys.capella.core.data.fa.FunctionKind;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateNodeTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class XBreakdownDiagram
extends CommonDiagram {
    BlockArchitectureExt.Type type = null;

    public XBreakdownDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(context, diagram);
        this.type = type;
    }

    public static XBreakdownDiagram createCBDiagram(SessionContext executionContext, String targetIdentifier) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        String name = null;
        if (type == BlockArchitectureExt.Type.OA) {
            name = "Operational Entity Breakdown";
        } else if (type == BlockArchitectureExt.Type.LA) {
            name = "Logical Component Breakdown";
        } else if (type == BlockArchitectureExt.Type.PA) {
            name = "Physical Component Breakdown";
        } else if (type == BlockArchitectureExt.Type.EPBS) {
            name = "Configuration Items Breakdown";
        }
        return (XBreakdownDiagram)((DiagramContext)((Object)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new XBreakdownDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run())).open();
    }

    public static XBreakdownDiagram createFBDiagram(SessionContext executionContext, String targetIdentifier) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        String name = null;
        if (type == BlockArchitectureExt.Type.OA) {
            name = "Operational Activity Breakdown";
        } else if (type == BlockArchitectureExt.Type.SA) {
            name = "System Function Breakdown";
        } else if (type == BlockArchitectureExt.Type.LA) {
            name = "Logical Function Breakdown";
        } else if (type == BlockArchitectureExt.Type.PA) {
            name = "Physical Function Breakdown";
        }
        return (XBreakdownDiagram)((DiagramContext)((Object)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new XBreakdownDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run())).open();
    }

    public static XBreakdownDiagram openDiagram(SessionContext executionContext, String name, final BlockArchitectureExt.Type type) {
        return (XBreakdownDiagram)((DiagramContext)((Object)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new XBreakdownDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run())).open();
    }

    public void createFunction(String id, final int expectedNewElements, String kind, String containerId, final String realContainerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "Operational Activity";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            if (FunctionKind.FUNCTION.getLiteral().equals(kind)) {
                name = "System Function";
            } else if (FunctionKind.DUPLICATE.getLiteral().equals(kind)) {
                name = "Duplicate";
            } else if (FunctionKind.GATHER.getLiteral().equals(kind)) {
                name = "Gather";
            } else if (FunctionKind.ROUTE.getLiteral().equals(kind)) {
                name = "Route";
            } else if (FunctionKind.SELECT.getLiteral().equals(kind)) {
                name = "Select";
            } else if (FunctionKind.SPLIT.getLiteral().equals(kind)) {
                name = "Split";
            }
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            if (FunctionKind.FUNCTION.getLiteral().equals(kind)) {
                name = "Logical Function";
            } else if (FunctionKind.DUPLICATE.getLiteral().equals(kind)) {
                name = "Duplicate";
            } else if (FunctionKind.GATHER.getLiteral().equals(kind)) {
                name = "Gather";
            } else if (FunctionKind.ROUTE.getLiteral().equals(kind)) {
                name = "Route";
            } else if (FunctionKind.SELECT.getLiteral().equals(kind)) {
                name = "Select";
            } else if (FunctionKind.SPLIT.getLiteral().equals(kind)) {
                name = "Split";
            }
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            if (FunctionKind.FUNCTION.getLiteral().equals(kind)) {
                name = "Physical Function";
            } else if (FunctionKind.DUPLICATE.getLiteral().equals(kind)) {
                name = "Duplicate";
            } else if (FunctionKind.GATHER.getLiteral().equals(kind)) {
                name = "Gather";
            } else if (FunctionKind.ROUTE.getLiteral().equals(kind)) {
                name = "Route";
            } else if (FunctionKind.SELECT.getLiteral().equals(kind)) {
                name = "Select";
            } else if (FunctionKind.SPLIT.getLiteral().equals(kind)) {
                name = "Split";
            }
        }
        new CreateNodeTool(this, name, containerId, id){

            @Override
            protected DSemanticDecorator getContainerView() {
                return this.getExecutionContext().getView(realContainerId != null && !"".equals(realContainerId) ? realContainerId : this.containerView);
            }

            @Override
            protected int expectedNewElements() {
                return expectedNewElements;
            }
        }.run();
    }

    public void createComponent(String id, int expectedNewElements, String containerId) {
        this.createComponent(id, expectedNewElements, "", containerId, containerId);
    }

    public void createComponent(String id, final int expectedNewElements, String kind, String containerId, final String realContainerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = OaPackage.Literals.OPERATIONAL_ACTOR.getName().equals(kind) ? "Operational Actor" : "Operational Entity";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Logical Component";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            if (PhysicalComponentNature.BEHAVIOR.getLiteral().equals(kind)) {
                name = "Behavior PC";
            } else if (PhysicalComponentNature.NODE.getLiteral().equals(kind)) {
                name = "Node PC";
            }
        } else if (this.type == BlockArchitectureExt.Type.EPBS) {
            if (ConfigurationItemKind.COTSCI.getLiteral().equals(kind)) {
                name = "COTS";
            } else if (ConfigurationItemKind.CSCI.getLiteral().equals(kind)) {
                name = "CS";
            } else if (ConfigurationItemKind.HWCI.getLiteral().equals(kind)) {
                name = "HW";
            } else if (ConfigurationItemKind.INTERFACE_CI.getLiteral().equals(kind)) {
                name = "Interface";
            } else if (ConfigurationItemKind.NDICI.getLiteral().equals(kind)) {
                name = "NDI";
            } else if (ConfigurationItemKind.PRIME_ITEM_CI.getLiteral().equals(kind)) {
                name = "Prime Item";
            } else if (ConfigurationItemKind.SYSTEM_CI.getLiteral().equals(kind)) {
                name = "System";
            }
        }
        new CreateNodeTool(this, name, containerId, id){

            @Override
            protected DSemanticDecorator getContainerView() {
                return this.getExecutionContext().getView(realContainerId != null && !"".equals(realContainerId) ? realContainerId : this.containerView);
            }

            @Override
            protected int expectedNewElements() {
                return expectedNewElements;
            }
        }.run();
    }

    public void createCContainedIn(String sourceId, String targetId) {
        this.createCContainedIn(sourceId, targetId, null);
    }

    public void createCContainedIn(String sourceId, String targetId, String id) {
        String name = null;
        if (this.isA("Operational Entity Breakdown")) {
            name = "Contained In";
        } else if (this.isA("Logical Component Breakdown")) {
            name = "Contained In";
        } else if (this.isA("Physical Component Breakdown")) {
            name = "Contained In";
        } else if (this.isA("Configuration Items Breakdown")) {
            name = "Contained In";
        }
        new CreateDEdgeTool(this, name, sourceId, targetId, id).run();
    }

    public void createFContainedIn(String sourceId, String targetId) {
        this.createFContainedIn(sourceId, targetId, null);
    }

    public void createFContainedIn(String sourceId, String targetId, String id) {
        String name = null;
        if (this.isA("Operational Activity Breakdown")) {
            name = "Contained In";
        } else if (this.isA("System Function Breakdown")) {
            name = "Contained In";
        } else if (this.isA("Logical Function Breakdown")) {
            name = "Contained In";
        } else if (this.isA("Physical Function Breakdown")) {
            name = "Contained In";
        }
        new CreateDEdgeTool(this, name, sourceId, targetId, id).run();
    }

    public void createPart(String sourceId, String targetId) {
        this.createPart(sourceId, targetId, this.getDiagramId());
    }

    public void createPart(String sourceId, String targetId, String id) {
        String name = null;
        if (this.isA("Logical Component Breakdown")) {
            name = "Create Part";
        } else if (this.isA("Physical Component Breakdown")) {
            name = "Create Part";
        }
        new CreateDEdgeTool(this, name, sourceId, targetId, id).run();
    }
}

