/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreatePathTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InitializationFromExistingDiagramTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class XDFBDiagram
extends DiagramContext {
    BlockArchitectureExt.Type type = null;

    public XDFBDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(context, diagram);
        this.type = type;
    }

    public static XDFBDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        String name = null;
        if (type == BlockArchitectureExt.Type.OA) {
            name = "Operational Activity Interaction Blank";
        } else if (type == BlockArchitectureExt.Type.SA) {
            name = "System Data Flow Blank";
        } else if (type == BlockArchitectureExt.Type.LA) {
            name = "Logical Data Flow Blank";
        } else if (type == BlockArchitectureExt.Type.PA) {
            name = "Physical Data Flow Blank";
        }
        return (XDFBDiagram)((DiagramContext)((Object)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new XDFBDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run())).open();
    }

    public static XDFBDiagram openDiagram(SessionContext executionContext, String name, final BlockArchitectureExt.Type type) {
        return (XDFBDiagram)((DiagramContext)((Object)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new XDFBDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run())).open();
    }

    public void createFunction(String id) {
        this.createFunction(id, this.getDiagramId());
    }

    public void createFunction(String id, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "Operational Activity";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "System Function";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Logical Function";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "Physical Function";
        }
        new CreateContainerTool((DiagramContext)this, name, containerId, id).run();
    }

    public void createActorFunction(String id) {
        this.createActorFunction(id, this.getDiagramId());
    }

    public void createActorFunction(String id, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.SA) {
            name = "Actor Function";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Actor Function";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "Actor Function";
        }
        new CreateContainerTool((DiagramContext)this, name, containerId, id).run();
    }

    public void createFunctionalExchange(String id, String sourceViewId, String targetViewId, String newSourceIdentifier, String newTargetIdentifier) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "Interaction";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "Functional Exchange";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "Functional Exchange";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "Functional Exchange";
        }
        new CreateDEdgeTool(this, name, sourceViewId, targetViewId, id, newSourceIdentifier, newTargetIdentifier).run();
    }

    public void createFunctionalExchange(String id, String sourceViewId, String targetViewId) {
        this.createFunctionalExchange(id, sourceViewId, targetViewId, null, null);
    }

    public void initializationFromExistingDiagram(DiagramContext existingContext) {
        new InitializationFromExistingDiagramTool((DiagramContext)this, "Initialization from existing diagram", existingContext).insert(existingContext.getDiagramId());
    }

    public void insertFunction(String containerId, String id) {
        if (this.type == BlockArchitectureExt.Type.SA) {
            new InsertRemoveTool((DiagramContext)this, "Show/Hide Functions", containerId).insert(id);
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            new InsertRemoveTool((DiagramContext)this, "Show/Hide Functions", containerId).insert(id);
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            new InsertRemoveTool((DiagramContext)this, "Show/Hide Functions", containerId).insert(id);
        }
    }

    public void removeFunction(String containerId, String id) {
        if (this.type == BlockArchitectureExt.Type.SA) {
            new InsertRemoveTool((DiagramContext)this, "Show/Hide Functions", containerId).remove(id);
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            new InsertRemoveTool((DiagramContext)this, "Show/Hide Functions", containerId).remove(id);
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            new InsertRemoveTool((DiagramContext)this, "Show/Hide Functions", containerId).remove(id);
        }
    }

    public void insertFunctionalExchange(String containerId, String id) {
        if (this.type == BlockArchitectureExt.Type.SA) {
            new InsertRemoveTool((DiagramContext)this, "Show/Hide Functional Exchanges", containerId).insert(id);
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            new InsertRemoveTool((DiagramContext)this, "Show/Hide Functional Exchanges", containerId).insert(id);
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            new InsertRemoveTool((DiagramContext)this, "Show/Hide Functional Exchanges", containerId).insert(id);
        }
    }

    public void removeFunctionalExchange(String containerId, String id) {
        if (this.type == BlockArchitectureExt.Type.SA) {
            new InsertRemoveTool((DiagramContext)this, "Show/Hide Functional Exchanges", containerId).remove(id);
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            new InsertRemoveTool((DiagramContext)this, "Show/Hide Functional Exchanges", containerId).remove(id);
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            new InsertRemoveTool((DiagramContext)this, "Show/Hide Functional Exchanges", containerId).remove(id);
        }
    }

    public void createFunctionalChain(String path, String ... links) {
        new CreatePathTool(this, "Functional Chain", path, links).run();
    }
}

