/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.crud;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.junit.Assert;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.diagram.helpers.DiagramHelper;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.headless.selector.HeadlessCapellaAnalysisSelector;
import org.polarsys.capella.test.diagram.common.ju.step.Messages;
import org.polarsys.capella.test.framework.api.step.AbstractTestStep;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class CreateDiagramStep
extends AbstractTestStep<DiagramContext> {
    protected DDiagram diagram;
    protected RepresentationDescription description;
    protected EObject target;
    protected boolean isSynchronized;
    protected URI selectedURI;

    public CreateDiagramStep(SessionContext executionContext, String targetIdentifier, String diagramDescription) {
        this(executionContext, executionContext.getSemanticElement(targetIdentifier), diagramDescription, TestHelper.getAirdResource((Session)executionContext.getSession()).getURI());
    }

    public CreateDiagramStep(SessionContext executionContext, String targetIdentifier, String diagramDescription, URI selectedURI) {
        this(executionContext, executionContext.getSemanticElement(targetIdentifier), diagramDescription, selectedURI);
    }

    public CreateDiagramStep(SessionContext executionContext, EObject target, String diagramDescription, URI selectedURI) {
        super(executionContext);
        this.target = target;
        this.isSynchronized = true;
        this.description = DiagramHelper.getService().getDescription(executionContext.getSession(), diagramDescription);
        this.selectedURI = selectedURI;
    }

    protected void preRunTest() {
        super.preRunTest();
        Assert.assertNotNull((String)Messages.nullSession, (Object)this.getExecutionContext().getSession());
        Assert.assertNotNull((String)Messages.nullSemanticObject, (Object)this.target);
        Assert.assertNotNull((String)Messages.nullRepresentationDesc, (Object)this.description);
        HeadlessCapellaAnalysisSelector.INSTANCE.setSelectedURI(this.selectedURI);
    }

    protected void runTest() {
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                CreateDiagramStep.this.diagram = (DDiagram)DialectManager.INSTANCE.createRepresentation(CreateDiagramStep.this.description.getName(), CreateDiagramStep.this.target, CreateDiagramStep.this.description, CreateDiagramStep.this.getExecutionContext().getSession(), (IProgressMonitor)new NullProgressMonitor());
                if (CreateDiagramStep.this.diagram != null && CreateDiagramStep.this.diagram instanceof DDiagram) {
                    CreateDiagramStep.this.diagram.setSynchronized(CreateDiagramStep.this.isSynchronized);
                }
            }
        };
        this.getExecutionContext().getExecutionManager().execute((ICommand)cmd);
        Assert.assertNotNull((String)NLS.bind((String)Messages.failToCreateDriagram, (Object[])new Object[]{this.description.getName(), EObjectLabelProviderHelper.getText((EObject)this.target)}), (Object)this.diagram);
        SessionManager.INSTANCE.notifyRepresentationCreated(this.getExecutionContext().getSession());
    }

    public DiagramContext getResult() {
        DiagramContext diagramContext = new DiagramContext(this.getExecutionContext(), this.diagram);
        this.getExecutionContext().putSemanticElement(diagramContext.getDiagramId(), (EObject)this.diagram);
        return diagramContext;
    }
}

