/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.crud;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.junit.Assert;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.Messages;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.step.AbstractTestStep;
import org.polarsys.capella.test.framework.context.SessionContext;

public class OpenDiagramStep
extends AbstractTestStep<DiagramContext> {
    private boolean _mustBeRefreshed;
    protected DDiagram diagram;

    public OpenDiagramStep(SessionContext context_p, DDiagram diagram_p, boolean mustBeRefreshed) {
        super(context_p);
        this.diagram = diagram_p;
        this._mustBeRefreshed = false;
    }

    public OpenDiagramStep(DiagramContext diagramContext_p) {
        this(diagramContext_p, false);
    }

    public OpenDiagramStep(SessionContext context_p, String diagramName) {
        this(context_p, (DDiagram)DiagramHelper.getDRepresentation(context_p.getSession(), diagramName), false);
    }

    public OpenDiagramStep(DiagramContext executionContext, boolean mustBeRefreshed) {
        this(executionContext, executionContext.getDiagram(), mustBeRefreshed);
    }

    public OpenDiagramStep(SessionContext context_p, DDiagram diagram_p) {
        this(context_p, diagram_p, false);
    }

    protected void preRunTest() {
        super.preRunTest();
        Assert.assertNotNull((String)Messages.nullDiagram, (Object)this.diagram);
    }

    public DiagramContext getResult() {
        if (this.getExecutionContext() instanceof DiagramContext) {
            this.getExecutionContext().putSemanticElement(((DiagramContext)this.getExecutionContext()).getDiagramId(), (EObject)this.diagram);
            return (DiagramContext)this.getExecutionContext();
        }
        DiagramContext diagramContext = new DiagramContext(this.getExecutionContext(), this.diagram);
        this.getExecutionContext().putSemanticElement(diagramContext.getDiagramId(), (EObject)this.diagram);
        return diagramContext;
    }

    protected void runTest() {
        DiagramHelper.opendiagramEditor(this.getExecutionContext().getSession(), (DRepresentation)this.diagram);
        if (this._mustBeRefreshed || this.diagram.getOwnedRepresentationElements().isEmpty()) {
            boolean ret = DiagramHelper.refreshDiagram(this.diagram);
            Assert.assertTrue((String)NLS.bind((String)Messages.failToRefreshDiagram, (Object[])new Object[]{this.diagram.getName()}), (boolean)ret);
        }
    }
}

