/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.filters;

import java.text.MessageFormat;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.filter.CompositeFilterDescription;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.junit.Assert;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.AbstractDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.FilterOnDiagramHelper;

public class ChangeFilter
extends AbstractDiagramStep<DDiagramElement> {
    protected String filterName;
    protected ChangeType changeType;
    protected int nbOfexpectedHiddenElements;

    public ChangeFilter(DiagramContext context, String filterName, ChangeType changeType, int nbOfExpectedHiddenElements) {
        super(context);
        this.filterName = filterName;
        this.changeType = changeType;
        this.nbOfexpectedHiddenElements = nbOfExpectedHiddenElements;
    }

    public DDiagramElement getResult() {
        return null;
    }

    protected void runTest() {
        int nbElementsBeforeFilter = this.getExecutionContext().getDiagram().getDiagramElements().size();
        FilterDescription filterDescription = ChangeType.ADD == this.changeType ? FilterOnDiagramHelper.applyFilterOnDiagram(this.getExecutionContext().getDiagram(), this.filterName) : FilterOnDiagramHelper.removeFilterOnDiagram(this.getExecutionContext().getDiagram(), this.filterName);
        Assert.assertNotNull((String)MessageFormat.format("Filter \"{0}\" not found for diagram \"{1}\"", this.filterName, this.getExecutionContext().getDiagram().getName()), (Object)filterDescription);
        int numberOfHiddenElements = 0;
        EList diagramElements = this.getExecutionContext().getDiagram().getDiagramElements();
        for (DDiagramElement dDiagramElement : diagramElements) {
            if (dDiagramElement.isVisible()) continue;
            ++numberOfHiddenElements;
        }
        Assert.assertEquals((long)numberOfHiddenElements, (long)this.nbOfexpectedHiddenElements);
        if (ChangeType.ADD == this.changeType) {
            FilterOnDiagramHelper.checkFilteredElementsInDiagram(this.getExecutionContext().getDiagram(), (CompositeFilterDescription)filterDescription);
        } else {
            FilterOnDiagramHelper.checkShowElementsInDiagram(this.getExecutionContext().getDiagram(), (CompositeFilterDescription)filterDescription);
        }
        int nbElementsAfterFilter = this.getExecutionContext().getDiagram().getDiagramElements().size();
        Assert.assertEquals((long)nbElementsBeforeFilter, (long)nbElementsAfterFilter);
    }

    public static enum ChangeType {
        ADD,
        REMOVE;

    }
}

