/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.filters;

import org.junit.Assert;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.AbstractDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.FilterOnDiagramHelper;

public class FilterStep
extends AbstractDiagramStep<DiagramContext> {
    boolean initialized = false;
    boolean activate = false;
    String filterName;
    String containerId;
    String[] insertedElements;
    String[] removedElements;

    public FilterStep(DiagramContext context, String filterName) {
        super(context);
        this.filterName = filterName;
    }

    protected void initialize(boolean activate, String[] insertedElements_input, String[] removedElements_input) {
        this.activate = activate;
        this.insertedElements = insertedElements_input;
        if (this.insertedElements == null) {
            this.insertedElements = new String[0];
        }
        this.removedElements = removedElements_input;
        if (this.removedElements == null) {
            this.removedElements = new String[0];
        }
        this.initialized = true;
    }

    public DiagramContext run() {
        if (!this.initialized) {
            Assert.assertFalse((String)"Please use insert/remove methods instead of run.", (boolean)true);
        }
        return (DiagramContext)((Object)super.run());
    }

    public void activate(String ... toRemove) {
        this.initialize(true, null, toRemove);
        this.run();
    }

    public void desactivate(String ... toInsert) {
        this.initialize(false, toInsert, null);
        this.run();
    }

    protected void postRunTest() {
        String identifier;
        super.postRunTest();
        String[] stringArray = this.insertedElements;
        int n = this.insertedElements.length;
        int n2 = 0;
        while (n2 < n) {
            identifier = stringArray[n2];
            this.getExecutionContext().hasView(identifier);
            ++n2;
        }
        stringArray = this.removedElements;
        n = this.removedElements.length;
        n2 = 0;
        while (n2 < n) {
            identifier = stringArray[n2];
            this.getExecutionContext().hasFilteredView(identifier);
            ++n2;
        }
    }

    public DiagramContext getResult() {
        return this.getExecutionContext();
    }

    protected void runTest() {
        if (this.activate) {
            FilterOnDiagramHelper.applyFilterOnDiagram(this.getExecutionContext().getDiagram(), this.filterName);
        } else {
            FilterOnDiagramHelper.removeFilterOnDiagram(this.getExecutionContext().getDiagram(), this.filterName);
        }
    }
}

