/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools;

import java.util.Collection;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;

public class CreateAbstractDNodeTool<T extends AbstractDNode>
extends AbstractToolStep<T> {
    protected String newIdentifier;
    protected String targetContainerView;
    protected String containerView;
    protected Class<T> expectedDiagramElementType;
    protected Collection<DDiagramElement> elements;
    protected Collection<DDiagramElement> newElements;

    public CreateAbstractDNodeTool(DiagramContext context, String toolName, String containerView) {
        this(context, toolName, containerView, (Class<T>)null);
    }

    public CreateAbstractDNodeTool(DiagramContext context, String toolName, String containerView, Class<T> expectedNodeType) {
        super(context, toolName);
        this.targetContainerView = containerView;
        this.containerView = containerView;
        this.expectedDiagramElementType = expectedNodeType;
    }

    public CreateAbstractDNodeTool(DiagramContext context, String toolName, String containerView, String newIdentifier, Class<T> expectedNodeType) {
        this(context, toolName, containerView, expectedNodeType);
        this.newIdentifier = newIdentifier;
    }

    public CreateAbstractDNodeTool(DiagramContext context, String toolName, String targetContainerView, String containerView, String newIdentifier, Class<T> expectedNodeType) {
        this(context, toolName, targetContainerView, expectedNodeType);
        this.newIdentifier = newIdentifier;
        this.containerView = containerView;
    }

    public CreateAbstractDNodeTool(DiagramContext context, String toolName, String containerView, String newIdentifier) {
        this(context, toolName, containerView, newIdentifier, null);
    }

    public CreateAbstractDNodeTool(DiagramContext context, String[] toolIdentifier, String containerView, Class<T> expectedNodeType) {
        super(context, toolIdentifier[0], toolIdentifier[1]);
        this.targetContainerView = containerView;
        this.containerView = containerView;
        this.expectedDiagramElementType = expectedNodeType;
    }

    public CreateAbstractDNodeTool(DiagramContext context, String[] toolIdentifier, String containerView) {
        this(context, toolIdentifier, containerView, (Class<T>)null);
    }

    public CreateAbstractDNodeTool(DiagramContext context, String[] toolIdentifier, String containerView, String newIdentifier, Class<T> expectedNodeType) {
        this(context, toolIdentifier, containerView, expectedNodeType);
        this.newIdentifier = newIdentifier;
    }

    public CreateAbstractDNodeTool(DiagramContext context, String[] toolIdentifier, String containerView, String newIdentifier) {
        this(context, toolIdentifier, containerView, newIdentifier, null);
    }

    @Override
    protected void preRunTest() {
        super.preRunTest();
        DSemanticDecorator element = this.getContainerView();
        this.elements = DiagramHelper.getOwnedElements(element);
    }

    protected void dispose() {
        super.dispose();
        this.elements = null;
        this.newElements = null;
    }

    protected DSemanticDecorator getContainerView() {
        return this.getExecutionContext().getView(this.containerView);
    }

    protected int expectedNewElements() {
        return 1;
    }

    protected void postRunTest() {
        super.postRunTest();
        DSemanticDecorator element = this.getContainerView();
        this.newElements = DiagramHelper.getOwnedElements(element);
        this.newElements.removeAll(this.elements);
        if (this.newElements.size() != this.expectedNewElements()) {
            Assert.assertFalse((boolean)true);
        }
        if (this.expectedDiagramElementType != null && !this.expectedDiagramElementType.isInstance(this.newElements.iterator().next())) {
            Assert.assertFalse((boolean)true);
        }
    }

    public T getResult() {
        AbstractDNode view = (AbstractDNode)this.newElements.iterator().next();
        if (this.newIdentifier != null) {
            this.getExecutionContext().putSemanticElement(this.newIdentifier, view.getTarget());
            this.getExecutionContext().putView(this.newIdentifier, (DDiagramElement)view);
        }
        return (T)view;
    }

    @Override
    protected void initToolArguments() {
        DSemanticDecorator element = this.getExecutionContext().getView(this.targetContainerView);
        this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER, element.getTarget());
        this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, element);
    }
}

