/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;

public class CreateDEdgeTool
extends AbstractToolStep<DEdge> {
    String _sourceView;
    String _targetView;
    protected String _newIdentifier;
    String _newSourceIdentifier;
    String _newTargetIdentifier;
    Collection<DDiagramElement> _sourceElements;
    Collection<DDiagramElement> _targetElements;
    Collection<DDiagramElement> _newSourceElements;
    Collection<DDiagramElement> _newTargetElements;
    Collection<DDiagramElement> _edgesElements;
    protected Collection<DDiagramElement> _newEdgesElements;

    public CreateDEdgeTool(DiagramContext context, String toolName, String sourceView, String targetView) {
        super(context, toolName);
        this._sourceView = sourceView;
        this._targetView = targetView;
    }

    public CreateDEdgeTool(DiagramContext context, String toolName, String sourceView, String targetView, String newIdentifier) {
        this(context, toolName, sourceView, targetView);
        this._newIdentifier = newIdentifier;
    }

    public CreateDEdgeTool(DiagramContext context, String toolName, String sourceView, String targetView, String newIdentifier, String newSourceIdentifier, String newTargetIdentifier) {
        this(context, toolName, sourceView, targetView);
        this._newIdentifier = newIdentifier;
        this._newSourceIdentifier = newSourceIdentifier;
        this._newTargetIdentifier = newTargetIdentifier;
    }

    @Override
    protected void preRunTest() {
        super.preRunTest();
        this._sourceElements = DiagramHelper.getOwnedElements(this.getExecutionContext().getView(this._sourceView));
        this._targetElements = DiagramHelper.getOwnedElements(this.getExecutionContext().getView(this._targetView));
        this._edgesElements = new ArrayList<DDiagramElement>((Collection<DDiagramElement>)this.getExecutionContext().getDiagram().getEdges());
    }

    protected void dispose() {
        super.dispose();
        this._sourceElements = null;
        this._targetElements = null;
    }

    protected void postRunTest() {
        super.postRunTest();
        this._newSourceElements = DiagramHelper.getOwnedElements(this.getExecutionContext().getView(this._sourceView));
        this._newSourceElements.removeAll(this._sourceElements);
        this._newTargetElements = DiagramHelper.getOwnedElements(this.getExecutionContext().getView(this._targetView));
        this._newTargetElements.removeAll(this._targetElements);
        this._newEdgesElements = new ArrayList<DDiagramElement>((Collection<DDiagramElement>)this.getExecutionContext().getDiagram().getEdges());
        this._newEdgesElements.removeAll(this._edgesElements);
    }

    public DEdge getResult() {
        DEdge view = (DEdge)this._newEdgesElements.iterator().next();
        if (this._newIdentifier != null) {
            this.getExecutionContext().putSemanticElement(this._newIdentifier, view.getTarget());
            this.getExecutionContext().putView(this._newIdentifier, (DDiagramElement)view);
        }
        if (this._newSourceIdentifier != null && !this._newSourceElements.isEmpty()) {
            DDiagramElement sView = this._newSourceElements.iterator().next();
            this.getExecutionContext().putSemanticElement(this._newSourceIdentifier, sView.getTarget());
            this.getExecutionContext().putView(this._newSourceIdentifier, sView);
        }
        if (this._newTargetIdentifier != null && !this._newTargetElements.isEmpty()) {
            DDiagramElement tView = this._newTargetElements.iterator().next();
            this.getExecutionContext().putSemanticElement(this._newTargetIdentifier, tView.getTarget());
            this.getExecutionContext().putView(this._newTargetIdentifier, tView);
        }
        return view;
    }

    @Override
    protected void initToolArguments() {
        DSemanticDecorator source = this.getExecutionContext().getView(this._sourceView);
        this._toolWrapper.setArgumentValue(ArgumentType.SOURCE, source);
        DSemanticDecorator target = this.getExecutionContext().getView(this._targetView);
        this._toolWrapper.setArgumentValue(ArgumentType.TARGET, target);
    }
}

