/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;

public class CreateEdgeTool
extends AbstractToolStep<DEdge> {
    protected String sourceView;
    protected String targetView;
    protected String newIdentifier;
    protected int expectedNewElts;
    protected Collection<DDiagramElement> diagramElementsBefore;
    protected Collection<DDiagramElement> newDiagramElements;

    public CreateEdgeTool(DiagramContext context, String toolName, String newIdentifier, String sourceView, String targetView, int expectedNewElts) {
        super(context, toolName);
        this.sourceView = sourceView;
        this.targetView = targetView;
        this.newIdentifier = newIdentifier;
        this.expectedNewElts = expectedNewElts;
    }

    @Override
    protected void preRunTest() {
        super.preRunTest();
        this.diagramElementsBefore = this.getExecutionContext().getDiagram().getDiagramElements();
    }

    protected void dispose() {
        super.dispose();
        this.diagramElementsBefore = null;
        this.newDiagramElements = null;
    }

    protected void postRunTest() {
        super.postRunTest();
        this.newDiagramElements = new ArrayList<DDiagramElement>((Collection<DDiagramElement>)this.getExecutionContext().getDiagram().getDiagramElements());
        this.newDiagramElements.removeAll(this.diagramElementsBefore);
        Assert.assertEquals((long)this.expectedNewElts, (long)this.newDiagramElements.size());
        if (Collections2.filter(this.newDiagramElements, (Predicate)Predicates.instanceOf(DEdge.class)).size() != 1) {
            Assert.assertFalse((boolean)true);
        }
    }

    public DEdge getResult() {
        DEdge view = (DEdge)Iterables.find(this.newDiagramElements, (Predicate)Predicates.instanceOf(DEdge.class));
        if (this.newIdentifier != null) {
            this.getExecutionContext().putSemanticElement(this.newIdentifier, view.getTarget());
            this.getExecutionContext().putView(this.newIdentifier, (DDiagramElement)view);
        }
        return view;
    }

    @Override
    protected void initToolArguments() {
        DSemanticDecorator source = this.getExecutionContext().getView(this.sourceView);
        DSemanticDecorator target = this.getExecutionContext().getView(this.targetView);
        this._toolWrapper.setArgumentValue(ArgumentType.SOURCE, source);
        this._toolWrapper.setArgumentValue(ArgumentType.TARGET, target);
    }
}

