/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools;

import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.junit.Assert;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.Messages;
import org.polarsys.capella.test.diagram.common.ju.wrapper.factory.ToolWrapperFactory;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;

public class DeleteElementTool
extends AbstractToolStep {
    DDiagramElement _elementToDelete;
    DDiagram _containingToolDiagram;

    public DeleteElementTool(DiagramContext context, DiagramContext containingToolDiagramContext, String toolName) {
        super(context, toolName);
        this._containingToolDiagram = containingToolDiagramContext.getDiagram();
    }

    public void delete(DDiagramElement element) {
        this._elementToDelete = element;
        this.run();
    }

    @Override
    protected void initToolArguments() {
        this._toolWrapper.setArgumentValue(ArgumentType.TARGET, this._elementToDelete);
        this._toolWrapper.setArgumentValue(ArgumentType.ON_DIAGRAM_ONLY, false);
    }

    public Object getResult() {
        return null;
    }

    @Override
    protected void preRunTest() {
        AbstractToolDescription tool = this.getTool(this.getExecutionContext().getSession(), this._containingToolDiagram, this.toolName);
        Assert.assertNotNull((String)NLS.bind((String)Messages.toolDoesNotExist, (Object)this.toolName), (Object)tool);
        this._toolWrapper = ToolWrapperFactory.INSTANCE.createToolCommandWrapper(tool);
        Assert.assertNotNull((String)NLS.bind((String)Messages.toolWrapperNotAvailable, (Object)this.toolName), (Object)this._toolWrapper);
        this.initToolArguments();
        boolean isArgumentOk = this._toolWrapper.isArgumentsAreSet();
        Assert.assertTrue((String)Messages.toolWrapperArgumentErr, (boolean)isArgumentOk);
        boolean isContextOk = this._toolWrapper.isContextOk();
        Assert.assertTrue((String)NLS.bind((String)Messages.toolWrapperArgumentValueErr, (Object)this.toolName), (boolean)isContextOk);
    }

    private AbstractToolDescription getTool(Session session, DDiagram diagram, String toolName) {
        EList tools = new DiagramComponentizationManager().getAllTools(session.getSelectedViewpoints(true), diagram.getDescription());
        AbstractToolDescription theAbstractToolDescription = null;
        for (AbstractToolDescription current : tools) {
            if (!current.getName().equals(toolName)) continue;
            theAbstractToolDescription = current;
            break;
        }
        return theAbstractToolDescription;
    }
}

