/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.ext.base.Option;
import org.junit.Assert;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;

public class InitializationFromExistingDiagramTool
extends InsertRemoveTool {
    private DiagramContext existingDiagramContext;
    Predicate<Node> nodePredicate = new Predicate<Node>(){

        public boolean apply(Node input) {
            return input.eContainer() != null && input.eContainer() instanceof Diagram && input.getElement() != null;
        }
    };

    public InitializationFromExistingDiagramTool(DiagramContext context, String toolName, String containerId, DiagramContext existingDiagramContext) {
        super(context, toolName, containerId);
        this.existingDiagramContext = existingDiagramContext;
    }

    public InitializationFromExistingDiagramTool(DiagramContext context, String toolName, DiagramContext existingDiagramContext) {
        super(context, toolName);
        this.existingDiagramContext = existingDiagramContext;
    }

    public InitializationFromExistingDiagramTool(DiagramContext context, String[] toolIdentifier, String containerId, DiagramContext existingDiagramContext) {
        super(context, toolIdentifier, containerId);
        this.existingDiagramContext = existingDiagramContext;
    }

    public InitializationFromExistingDiagramTool(DiagramContext context, String[] toolIdentifier, DiagramContext existingDiagramContext) {
        super(context, toolIdentifier);
        this.existingDiagramContext = existingDiagramContext;
    }

    @Override
    protected void postRunTest() {
        DiagramHelper.refreshDiagram(this.getExecutionContext().getDiagram());
        Map<String, Point> existingLocationMap = this.getNameToLocationMap(this.existingDiagramContext.getDiagram());
        Map<String, Point> initializedDiagramLocationMap = this.getNameToLocationMap(this.getExecutionContext().getDiagram());
        boolean atLeastOneCheck = false;
        for (String key : initializedDiagramLocationMap.keySet()) {
            Point existingLocation = existingLocationMap.get(key);
            if (existingLocation == null) continue;
            atLeastOneCheck = true;
            Point initializedLocation = initializedDiagramLocationMap.get(key);
            Assert.assertEquals((long)existingLocation.x, (long)initializedLocation.x);
            Assert.assertEquals((long)existingLocation.y, (long)initializedLocation.y);
        }
        Assert.assertTrue((boolean)atLeastOneCheck);
    }

    private Map<String, Point> getNameToLocationMap(DDiagram dDiagram) {
        HashMap<String, Point> locationMap = new HashMap<String, Point>();
        DDiagramGraphicalQuery query = new DDiagramGraphicalQuery(dDiagram);
        Option option = query.getAssociatedGMFDiagram();
        if (option.some()) {
            Diagram diagram = (Diagram)option.get();
            UnmodifiableIterator nodesIterator = Iterators.filter((Iterator)Iterators.filter((Iterator)diagram.eAllContents(), Node.class), this.nodePredicate);
            while (nodesIterator.hasNext()) {
                Node node = (Node)nodesIterator.next();
                Point location = GMFHelper.getLocation((Node)node);
                locationMap.put(node.getElement().toString(), location);
            }
        }
        return locationMap;
    }
}

