/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.core.sirius.analysis.actions.extensions.AbstractExternalJavaAction;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.headless.HeadlessResultOpProvider;
import org.polarsys.capella.test.diagram.common.ju.headless.IHeadlessResult;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;

public class InsertRemoveTool
extends AbstractToolStep {
    boolean initialized = false;
    boolean insertAll = false;
    boolean removeAll = false;
    boolean autoRefresh = true;
    String containerId;
    protected String[] toInsert;
    protected String[] toRemove;
    protected String[] insertedElements;
    protected String[] removedElements;

    public InsertRemoveTool(DiagramContext context, String toolName) {
        this(context, toolName, context.getDiagramId());
    }

    public InsertRemoveTool(DiagramContext context, String[] toolIdentifier) {
        this(context, toolIdentifier, context.getDiagramId());
    }

    public InsertRemoveTool(DiagramContext context, String toolName, String containerId) {
        super(context, toolName);
        this.containerId = containerId;
    }

    public InsertRemoveTool(DiagramContext context, String[] toolIdentifier, String containerId) {
        super(context, toolIdentifier[0], toolIdentifier[1]);
        this.containerId = containerId;
    }

    public InsertRemoveTool(DiagramContext context, String toolName, String containerId, boolean autoRefresh) {
        this(context, toolName, containerId);
        this.autoRefresh = autoRefresh;
    }

    protected void initialize(boolean insertAll, boolean removeAll) {
        this.insertAll = insertAll;
        this.removeAll = removeAll;
        this.initialize(null, null, null, null);
    }

    protected void initialize(String[] toInsert, String[] toRemove, String[] insertedElements, String[] removedElements) {
        this.toInsert = toInsert;
        if (toInsert == null) {
            this.toInsert = new String[0];
        }
        this.toRemove = toRemove;
        if (toRemove == null) {
            this.toRemove = new String[0];
        }
        this.insertedElements = insertedElements;
        if (insertedElements == null) {
            this.insertedElements = new String[0];
        }
        this.removedElements = removedElements;
        if (removedElements == null) {
            this.removedElements = new String[0];
        }
        this.initialized = true;
    }

    public Object run() {
        if (!this.initialized) {
            Assert.fail((String)"Please use insert/remove methods instead of run.");
        }
        return super.run();
    }

    public void insertAll() {
        this.initialize(true, false);
        this.run();
    }

    public void insert(String ... toInsert) {
        this.initialize(toInsert, null, toInsert, null);
        this.run();
    }

    public void insert(String[] toInsert, String[] insertedElements, String[] removedElements) {
        this.initialize(toInsert, null, insertedElements, removedElements);
        this.run();
    }

    public void remove(String ... toRemove) {
        this.initialize(null, toRemove, null, toRemove);
        this.run();
    }

    public void remove(String[] toRemove, String[] insertedElements, String[] removedElements) {
        this.initialize(null, toRemove, insertedElements, removedElements);
        this.run();
    }

    public void insertRemove(String[] toInsert, String[] toRemove, String[] insertedElements, String[] removedElements) {
        this.initialize(null, toRemove, insertedElements, removedElements);
        this.run();
    }

    @Override
    protected void preRunTest() {
        HeadlessResultOpProvider.INSTANCE.setCurrentOp(this.createOperation());
        super.preRunTest();
    }

    protected IHeadlessResult createOperation() {
        return new IHeadlessResult(){

            @Override
            public Object getResult(Collection<? extends EObject> selections, Map<String, Object> parameters) {
                if (InsertRemoveTool.this.insertAll) {
                    return AbstractExternalJavaAction.getScope(parameters);
                }
                if (InsertRemoveTool.this.removeAll) {
                    return Collections.emptyList();
                }
                HashSet<EObject> objects = new HashSet<EObject>();
                DiagramContext context = InsertRemoveTool.this.getExecutionContext();
                Collection<EObject> inserted = context.adaptTool(InsertRemoveTool.this, parameters, context.getSemanticElements(InsertRemoveTool.this.insertedElements));
                Collection<EObject> removed = context.adaptTool(InsertRemoveTool.this, parameters, context.getSemanticElements(InsertRemoveTool.this.removedElements));
                objects.addAll(AbstractExternalJavaAction.getInitialSelection(parameters));
                objects.addAll(inserted);
                objects.removeAll(removed);
                return new ArrayList(objects);
            }
        };
    }

    @Override
    protected void initToolArguments() {
        DSemanticDecorator containerView = this.getExecutionContext().getView(this.containerId);
        this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER, containerView.getTarget());
        this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, containerView);
    }

    protected void postRunTest() {
        String identifier;
        super.postRunTest();
        if (this.autoRefresh) {
            DiagramHelper.refreshDiagram(this.getExecutionContext().getDiagram());
        }
        String[] stringArray = this.insertedElements;
        int n = this.insertedElements.length;
        int n2 = 0;
        while (n2 < n) {
            identifier = stringArray[n2];
            this.getExecutionContext().hasView(identifier);
            ++n2;
        }
        stringArray = this.removedElements;
        n = this.removedElements.length;
        n2 = 0;
        while (n2 < n) {
            identifier = stringArray[n2];
            this.getExecutionContext().hasntView(identifier);
            ++n2;
        }
    }

    public Object getResult() {
        return null;
    }
}

