/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools.sequence;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.junit.Assert;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.headless.HeadlessResultOpProvider;
import org.polarsys.capella.test.diagram.common.ju.headless.IHeadlessResult;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.CommonTestMessages;

public class MessageCreationTool
extends CreateDEdgeTool {
    public MessageCreationTool(DiagramContext context, String toolName, String id, String sourceId, String targetId) {
        super(context, toolName, sourceId, targetId, id);
    }

    @Override
    protected void preRunTest() {
        HeadlessResultOpProvider.INSTANCE.setCurrentOp(this.createOperation());
        super.preRunTest();
    }

    protected IHeadlessResult createOperation() {
        return new IHeadlessResult(){

            @Override
            public Object getResult(Collection<? extends EObject> selections, Map<String, Object> parameters) {
                return MessageCreationTool.this.getExecutionContext().getSemanticElement(MessageCreationTool.this._newIdentifier);
            }
        };
    }

    @Override
    protected void postRunTest() {
        super.postRunTest();
        DDiagram diagram = this.getExecutionContext().getDiagram();
        DiagramHelper.refreshDiagram(diagram);
        EObject feToAdd = this.getExecutionContext().getSemanticElement(this._newIdentifier);
        String failMessage = NLS.bind((String)CommonTestMessages.objectRepresentationNotAvailableOnDiagram, (Object)EObjectLabelProviderHelper.getText((EObject)feToAdd), (Object)diagram.getName());
        if (this._newEdgesElements.size() == 1) {
            DDiagramElement view = (DDiagramElement)this._newEdgesElements.iterator().next();
            EList semanticElements = view.getSemanticElements();
            for (EObject semanticElement : semanticElements) {
                if (!(semanticElement instanceof FunctionalExchange)) continue;
                FunctionalExchange feAdded = (FunctionalExchange)semanticElement;
                Assert.assertEquals((String)failMessage, (Object)feToAdd, (Object)feAdded);
                return;
            }
        }
        Assert.fail((String)failMessage);
    }
}

