/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.wrapper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.polarsys.capella.test.diagram.common.ju.wrapper.Messages;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.InvalidArgumentException;

public abstract class AbstractToolWrapper {
    protected final AbstractToolDescription _tool;
    protected Map<ArgumentType, Object> _arguments;
    protected final List<ArgumentData> _argumentTypes;

    public AbstractToolWrapper(AbstractToolDescription tool) {
        this._tool = tool;
        this._arguments = new HashMap<ArgumentType, Object>();
        this._argumentTypes = this.getArgumentTypes();
    }

    public abstract List<ArgumentData> getArgumentTypes();

    public abstract boolean isContextOk();

    public abstract Command createCommand();

    public final boolean isArgumentsAreSet() {
        return this.checkArguments().isOK();
    }

    public final IStatus checkArguments() {
        boolean ret = true;
        MultiStatus result = new MultiStatus("org.polarsys.capella.test.diagram.common.ju", 0, "isArgumentsAreSet", null);
        Iterator<ArgumentData> it = this.getArgumentTypes().iterator();
        while (it.hasNext() && ret) {
            ArgumentData currentArgumentData = it.next();
            ArgumentType currentType = currentArgumentData.getType();
            if (currentType.equals((Object)ArgumentType.PREDECESSOR) && this._arguments.get((Object)currentType) == null || currentType.equals((Object)ArgumentType.STARTINGENDPREDECESSOR) && this._arguments.get((Object)currentType) == null || currentType.equals((Object)ArgumentType.FINISHINGENDPREDECESSOR) && this._arguments.get((Object)currentType) == null) {
                result.add((IStatus)new Status(0, "org.polarsys.capella.test.diagram.common.ju", (Object)((Object)currentType) + " is ok"));
                return result;
            }
            if (!this._arguments.containsKey((Object)currentType) || this._arguments.get((Object)currentType) == null) {
                result.add((IStatus)new Status(4, "org.polarsys.capella.test.diagram.common.ju", (Object)((Object)currentType) + " is not set or null"));
                continue;
            }
            ret = this.checkValue(currentType);
            if (ret) {
                result.add((IStatus)new Status(0, "org.polarsys.capella.test.diagram.common.ju", (Object)((Object)currentType) + " is ok"));
                continue;
            }
            result.add((IStatus)new Status(4, "org.polarsys.capella.test.diagram.common.ju", (Object)((Object)currentType) + " is not value"));
        }
        return result;
    }

    public final void setArgumentValue(ArgumentType argumentType, Object value) {
        if (this.isArgumentTypeRequired(argumentType)) {
            this._arguments.put(argumentType, value);
        }
    }

    public final Object getArgumentValue(ArgumentType argumentType) throws InvalidArgumentException {
        if (!this.isArgumentTypeRequired(argumentType)) {
            throw new InvalidArgumentException(NLS.bind((String)Messages.argumentNotInTheScopeOfWrapper, (Object[])new Object[]{argumentType.getLiteral(), this._tool.getName()}));
        }
        return this._arguments.get((Object)argumentType);
    }

    public final boolean checkValue(ArgumentType argumentType) throws InvalidArgumentException {
        boolean ret = true;
        if (!this.isArgumentTypeRequired(argumentType)) {
            throw new InvalidArgumentException(NLS.bind((String)Messages.argumentNotInTheScopeOfWrapper, (Object[])new Object[]{argumentType.getLiteral(), this._tool.getName()}));
        }
        if (argumentType == ArgumentType.COLLECTION) {
            return this.checkValueForCollectionType(argumentType);
        }
        Object matchingArgument = this._arguments.get((Object)argumentType);
        if (matchingArgument instanceof DDiagram) {
            return true;
        }
        if (!argumentType.getClassType().isAssignableFrom(matchingArgument.getClass())) {
            ret = false;
        }
        if (argumentType.getClassType().equals(EObject.class)) {
            EObject eObject = (EObject)matchingArgument;
            EClass eClass = eObject.eClass();
            ArgumentData argData = this.getArgumentData(argumentType);
            EClass tgtEclass = argData.getEClass();
            if (tgtEclass != null && !tgtEclass.isSuperTypeOf(eClass)) {
                ret = false;
            }
        }
        return ret;
    }

    protected final boolean checkValueForCollectionType(ArgumentType argumentType) {
        Collection col;
        boolean ret = true;
        Object matchingArgument = this._arguments.get((Object)argumentType);
        if (!argumentType.getClassType().isAssignableFrom(matchingArgument.getClass())) {
            ret = false;
        }
        if (!(col = (Collection)matchingArgument).isEmpty()) {
            ArgumentData argData = this.getArgumentData(argumentType);
            EClass tgtEclass = argData.getEClass();
            Iterator it = col.iterator();
            EObject eObject = null;
            EClass eClass = null;
            while (it.hasNext()) {
                eObject = (EObject)it.next();
                eClass = eObject.eClass();
                if (tgtEclass == null || tgtEclass.isSuperTypeOf(eClass)) continue;
                ret = false;
            }
        } else {
            ret = false;
        }
        if (argumentType.getClassType().equals(EObject.class)) {
            EObject eObject = (EObject)matchingArgument;
            EClass eClass = eObject.eClass();
            ArgumentData argData = this.getArgumentData(argumentType);
            EClass tgtEclass = argData.getEClass();
            if (tgtEclass != null && !tgtEclass.isSuperTypeOf(eClass)) {
                ret = false;
            }
        }
        return ret;
    }

    public final void clearArgumentValues() {
        this._arguments.clear();
    }

    protected boolean isArgumentTypeRequired(ArgumentType argumentType) {
        boolean ret = false;
        for (ArgumentData current : this.getArgumentTypes()) {
            if (!current.getType().equals((Object)argumentType)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    protected ArgumentData getArgumentData(ArgumentType argumentType) {
        ArgumentData ret = null;
        for (ArgumentData current : this.getArgumentTypes()) {
            if (!current.getType().equals((Object)argumentType)) continue;
            ret = current;
            break;
        }
        return ret;
    }

    public class ArgumentData {
        protected ArgumentType _type;
        protected EClass _eClass = null;

        public ArgumentData(ArgumentType type) {
            this._type = type;
        }

        public ArgumentData(ArgumentType type, EClass eClass) {
            this._type = type;
            this._eClass = eClass;
        }

        public ArgumentType getType() {
            return this._type;
        }

        public EClass getEClass() {
            return this._eClass;
        }
    }
}

