/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.wrapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.tool.ReconnectEdgeDescription;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.tools.api.interpreter.InterpreterRegistry;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.polarsys.capella.core.sirius.analysis.tool.StringUtil;
import org.polarsys.capella.test.diagram.common.ju.wrapper.AbstractCommonToolWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.AbstractToolWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;

public class ReconnectEdgeDescriptionWrapper
extends AbstractCommonToolWrapper {
    public ReconnectEdgeDescriptionWrapper(AbstractToolDescription tool, IDiagramCommandFactory commandFactory) {
        super(tool, commandFactory);
    }

    @Override
    public Command createCommand() {
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        if (this.isContextOk()) {
            ReconnectEdgeDescription tool = (ReconnectEdgeDescription)this._tool;
            DEdge edge = (DEdge)this._arguments.get((Object)ArgumentType.EDGE);
            EdgeTarget source = (EdgeTarget)this._arguments.get((Object)ArgumentType.SOURCE);
            EdgeTarget target = (EdgeTarget)this._arguments.get((Object)ArgumentType.TARGET);
            cmd = this._diagramCommandFactory.buildReconnectEdgeCommandFromTool(tool, edge, source, target);
        }
        return cmd;
    }

    @Override
    public List<AbstractToolWrapper.ArgumentData> getArgumentTypes() {
        List ret = null;
        if (this._argumentTypes == null) {
            ArrayList list = new ArrayList();
            Collections.addAll(list, new AbstractToolWrapper.ArgumentData(ArgumentType.SOURCE, DiagramPackage.Literals.EDGE_TARGET), new AbstractToolWrapper.ArgumentData(ArgumentType.TARGET, DiagramPackage.Literals.EDGE_TARGET), new AbstractToolWrapper.ArgumentData(ArgumentType.EDGE, DiagramPackage.Literals.DEDGE));
            ret = Collections.unmodifiableList(list);
        } else {
            ret = this._argumentTypes;
        }
        return ret;
    }

    @Override
    public boolean isContextOk() {
        boolean ret = true;
        if (!this.isArgumentsAreSet()) {
            ret = false;
        }
        if (ret) {
            ReconnectEdgeDescription tool = (ReconnectEdgeDescription)this._tool;
            EdgeTarget source = (EdgeTarget)this._arguments.get((Object)ArgumentType.SOURCE);
            EdgeTarget target = (EdgeTarget)this._arguments.get((Object)ArgumentType.TARGET);
            DEdge edge = (DEdge)this._arguments.get((Object)ArgumentType.EDGE);
            EObject semanticSource = ((DSemanticDecorator)source).getTarget();
            EObject semanticTarget = ((DSemanticDecorator)target).getTarget();
            EObject semanticElement = edge.getTarget();
            String precondition = tool.getPrecondition();
            if (precondition != null && !StringUtil.isEmpty((String)precondition)) {
                InterpreterRegistry interpreterRegistry = SiriusPlugin.getDefault().getInterpreterRegistry();
                IInterpreter interpreter = interpreterRegistry.getInterpreter(semanticElement);
                interpreter.setVariable("source", (Object)semanticSource);
                interpreter.setVariable("target", (Object)semanticTarget);
                interpreter.setVariable("element", (Object)semanticElement);
                interpreter.setVariable("sourceView", (Object)source);
                interpreter.setVariable("targetView", (Object)target);
                RuntimeLoggerInterpreter decorate = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
                EAttribute abstractToolDescription_Precondition = ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition();
                boolean result = decorate.evaluateBoolean(semanticElement, (EObject)tool, (EStructuralFeature)abstractToolDescription_Precondition);
                if (!result) {
                    ret = false;
                }
                interpreter.unSetVariable("source");
                interpreter.unSetVariable("target");
                interpreter.unSetVariable("element");
            }
        }
        return ret;
    }
}

