/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.wrapper.utils;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.listener.NotificationUtil;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.ui.business.api.helper.graphicalfilters.CompositeFilterApplicationBuilder;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.CopyFormatAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.PasteFormatAction;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.preferences.SiriusUIPreferencesKeys;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.ef.command.AbstractNonDirtyingCommand;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.mdsofa.common.helper.FileHelper;
import org.polarsys.capella.core.diagram.helpers.ContextualDiagramHelper;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.Messages;
import org.polarsys.capella.test.framework.api.CommonTestMessages;
import org.polarsys.capella.test.framework.helpers.GuiActions;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class DiagramHelper {
    public static void setSynchronized(final DDiagram diagram, final boolean isSynchronized) {
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                diagram.setSynchronized(isSynchronized);
                DiagramHelper.refreshDiagram(diagram);
            }
        };
        TestHelper.getExecutionManager((EObject)diagram).execute((ICommand)cmd);
    }

    public static void setPreferenceAutoRefresh(boolean value) {
        IPreferenceStore preferenceStore = SiriusEditPlugin.getPlugin().getPreferenceStore();
        preferenceStore.setValue(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), value);
    }

    public static void setPrefereneRefreshOnOpening(boolean value) {
        IPreferenceStore preferenceStore = SiriusEditPlugin.getPlugin().getPreferenceStore();
        preferenceStore.setValue(SiriusUIPreferencesKeys.PREF_REFRESH_ON_REPRESENTATION_OPENING.name(), value);
    }

    public static DRepresentation getDRepresentation(Session session, String name) {
        DRepresentation result = null;
        Collection dRepresentations = DialectManager.INSTANCE.getAllRepresentations(session);
        Iterator it = dRepresentations.iterator();
        while (it.hasNext() && result == null) {
            result = (DRepresentation)it.next();
            if (result.getName().equals(name)) continue;
            result = null;
        }
        return result;
    }

    public static DRepresentation getDRepresentationByID(Session session, String name, String id) {
        DRepresentation result = null;
        EAttribute featureToCompare = ModellingcorePackage.Literals.MODEL_ELEMENT__ID;
        Collection dRepresentations = DialectManager.INSTANCE.getAllRepresentations(session);
        for (DRepresentation dRepresentation : dRepresentations) {
            DSemanticDiagram dRepresentationDiagram;
            EObject semanticTarget;
            if (!dRepresentation.getName().equals(name) || !(semanticTarget = (dRepresentationDiagram = (DSemanticDiagram)dRepresentation).getTarget()).eGet((EStructuralFeature)featureToCompare).equals(id)) continue;
            result = dRepresentation;
        }
        return result;
    }

    public static void checkDiagramInSession(DRepresentation representation, String filepath) {
        URI representationURI = representation.eResource().getURI();
        boolean containsRepresentation = representationURI.equals(FileHelper.getFileFullUri((String)filepath));
        Assert.assertTrue((String)MessageFormat.format("The representation {0}  is not in  the resource {1}", representation, filepath), (boolean)containsRepresentation);
    }

    public static DRepresentation getDRepresentation(Session session, String name, String platformSpecificElementId) {
        DRepresentation result = null;
        Collection dRepresentations = DialectManager.INSTANCE.getAllRepresentations(session);
        for (DRepresentation next : dRepresentations) {
            if (!next.getName().equalsIgnoreCase(name) || !next.eResource().getURIFragment((EObject)next).equalsIgnoreCase(platformSpecificElementId)) continue;
            result = next;
            break;
        }
        return result;
    }

    public static DDiagramElement getOnDiagram(DDiagram diagram, EObject semanticObject) {
        LinkedList elements = new LinkedList(diagram.getDiagramElements());
        for (DDiagramElement element : elements) {
            if (element.getTarget() != semanticObject) continue;
            return element;
        }
        return null;
    }

    public static DDiagramElement getOnDiagram(DDiagram diagram, EObject semanticObject, EObject container) {
        LinkedList elements = new LinkedList(diagram.getDiagramElements());
        for (DDiagramElement element : elements) {
            if (!container.equals(element.eContainer()) || element.getTarget() != semanticObject) continue;
            return element;
        }
        return null;
    }

    public static DDiagramElement getOnDiagramByID(DDiagram diagram, String anID) {
        LinkedList elements = new LinkedList(diagram.getDiagramElements());
        for (DDiagramElement element : elements) {
            if (!element.getTarget().eGet((EStructuralFeature)ModellingcorePackage.Literals.MODEL_ELEMENT__ID).equals(anID)) continue;
            return element;
        }
        return null;
    }

    public static DDiagramElement getOnDiagramByIDAndName(DDiagram diagram, String anID, String aName) {
        LinkedList elements = new LinkedList(diagram.getDiagramElements());
        for (DDiagramElement element : elements) {
            if (!element.getTarget().eGet((EStructuralFeature)ModellingcorePackage.Literals.MODEL_ELEMENT__ID).equals(anID) || !element.getName().equals(aName)) continue;
            return element;
        }
        return null;
    }

    public static DDiagramElement getOnDiagramByIDandContainer(DDiagram diagram, String anID, EObject container) {
        LinkedList elements = new LinkedList(diagram.getDiagramElements());
        for (DDiagramElement element : elements) {
            if (!element.getTarget().eGet((EStructuralFeature)ModellingcorePackage.Literals.MODEL_ELEMENT__ID).equals(anID) || !element.eContainer().equals(container)) continue;
            return element;
        }
        return null;
    }

    public static DDiagramElement getOnDiagramNodeElement(DDiagram diagram, EObject semanticObject) {
        LinkedList elements = new LinkedList(diagram.getDiagramElements());
        for (DDiagramElement element : elements) {
            if (element.getTarget() != semanticObject || element instanceof DEdge) continue;
            return element;
        }
        return null;
    }

    public static DDiagramElement getDDiagramElementByEClass(DDiagram diagram, EObject semanticObject, EClass expectedSemanticMetaClass) {
        LinkedList elements = new LinkedList(diagram.getDiagramElements());
        for (DDiagramElement element : elements) {
            if (element.getTarget() != semanticObject || !expectedSemanticMetaClass.isSuperTypeOf(element.eClass())) continue;
            return element;
        }
        return null;
    }

    public static DDiagramElement getDDiagramElementBySourceAndTarget(DDiagram diagram, EObject semanticObject, EObject source, EObject target) {
        LinkedList elements = new LinkedList(diagram.getDiagramElements());
        for (DDiagramElement element : elements) {
            if (!(element instanceof DEdge)) continue;
            DEdge edge = (DEdge)element;
            if (element.getTarget() != semanticObject || !edge.getSourceNode().equals(source) || !edge.getTargetNode().equals(target)) continue;
            return element;
        }
        return null;
    }

    public static List<RepresentationDescription> getMatchingRepresentationDescription(Session session, EObject semanticElement) {
        ArrayList<RepresentationDescription> result = new ArrayList<RepresentationDescription>();
        Collection selectedViewpoints = session.getSelectedViewpoints(false);
        Collection descriptions = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(selectedViewpoints, semanticElement);
        for (RepresentationDescription current : descriptions) {
            if (!DialectManager.INSTANCE.canCreate(semanticElement, current)) continue;
            result.add(current);
        }
        return result;
    }

    public static RepresentationDescription getRepresentationDescription(Session session, EObject semanticElement, String repDescName) {
        RepresentationDescription result = null;
        List<RepresentationDescription> list = DiagramHelper.getMatchingRepresentationDescription(session, semanticElement);
        if (!list.isEmpty()) {
            if (repDescName != null) {
                for (RepresentationDescription current : list) {
                    if (!current.getName().equals(repDescName)) continue;
                    result = current;
                    break;
                }
            } else {
                result = list.get(0);
            }
        }
        return result;
    }

    public static boolean refreshDiagram(final DDiagram diagram) {
        boolean ret = true;
        try {
            AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

                public void run() {
                    DialectManager.INSTANCE.refresh((DRepresentation)diagram, (IProgressMonitor)new NullProgressMonitor());
                }
            };
            TestHelper.getExecutionManager((EObject)diagram).execute((ICommand)cmd);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public static void activateDiagramLayer(final Layer targetLayer, final DDiagram diagram, final boolean activate) {
        AbstractNonDirtyingCommand cmd = new AbstractNonDirtyingCommand(){

            public void run() {
                boolean shouldRemoveLayer;
                NotificationUtil.sendNotification((EObject)diagram, (int)1, (int)2);
                EList activatedLayers = diagram.getActivatedLayers();
                boolean shouldAddLayer = activate && !EqualityHelper.contains((Collection)activatedLayers, (EObject)targetLayer);
                boolean bl = shouldRemoveLayer = !shouldAddLayer && EqualityHelper.contains((Collection)activatedLayers, (EObject)targetLayer);
                if (shouldAddLayer) {
                    activatedLayers.add(targetLayer);
                } else if (shouldRemoveLayer) {
                    Iterator iterator = activatedLayers.iterator();
                    boolean removed = false;
                    while (iterator.hasNext() && !removed) {
                        Layer layerToRemove = (Layer)iterator.next();
                        if (!EqualityHelper.areEquals((EObject)targetLayer, (EObject)layerToRemove)) continue;
                        iterator.remove();
                        removed = true;
                    }
                }
                CapellaServices.getService().forceRefresh(diagram);
                DisplayServiceManager.INSTANCE.getDisplayService().refreshAllElementsVisibility(diagram);
                NotificationUtil.sendNotification((EObject)diagram, (int)0, (int)2);
            }
        };
        TestHelper.getExecutionManager((EObject)diagram).execute((ICommand)cmd);
    }

    public static List<Layer> getContributedLayers(DiagramDescription diagramDescription, Collection<Viewpoint> viewpoints) {
        return new DiagramComponentizationManager().getAllLayers(viewpoints, diagramDescription);
    }

    public static IEditorPart getDiagramEditor(Session session, DDiagram diagram) {
        IEditingSession editingSession = SessionUIManager.INSTANCE.getUISession(session);
        DialectEditor editor = editingSession.getEditor((DRepresentation)diagram);
        return editor;
    }

    public static void copyLayout(DDiagram diagram) {
        Session session = SessionManager.INSTANCE.getSession(((DSemanticDecorator)diagram).getTarget());
        IEditorPart part = DiagramHelper.getDiagramEditor(session, diagram);
        if (part == null) {
            Assert.assertFalse((String)"Diagram is not open, can't copy layout", (boolean)true);
        }
        CopyFormatAction action = new CopyFormatAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IWorkbenchPart)part);
        action.init();
        action.run();
        GuiActions.flushASyncGuiThread();
    }

    public static void pasteLayout(DDiagram diagram) {
        Session session = SessionManager.INSTANCE.getSession(((DSemanticDecorator)diagram).getTarget());
        IEditorPart part = DiagramHelper.getDiagramEditor(session, diagram);
        if (part == null) {
            Assert.assertFalse((String)"Diagram is not open, can't paste layout", (boolean)true);
        }
        PasteFormatAction action = new PasteFormatAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IWorkbenchPart)part);
        action.init();
        action.run();
        GuiActions.flushASyncGuiThread();
        action.init();
        action.run();
        GuiActions.flushASyncGuiThread();
    }

    public static void closeEditor(Session session, DDiagram diagram) {
        IEditorPart editor = DiagramHelper.getDiagramEditor(session, diagram);
        DialectUIManager.INSTANCE.closeEditor(editor, true);
    }

    public static IEditorPart opendiagramEditor(Session session, DRepresentation drep) {
        return DialectUIManager.INSTANCE.openEditor(session, drep, (IProgressMonitor)new NullProgressMonitor());
    }

    public static Collection<DDiagramElement> getDiagramElements(DDiagram diagram) {
        return diagram.getDiagramElements();
    }

    public static void removeView(DDiagramElement element) {
        if (element instanceof AbstractDNode) {
            DiagramServices.getDiagramServices().removeAbstractDNodeView((AbstractDNode)element);
        } else if (element instanceof DEdge) {
            DiagramServices.getDiagramServices().removeEdgeView((DEdge)element);
        } else if (element instanceof DDiagram || element instanceof DDiagramElementContainer) {
            DiagramServices.getDiagramServices().removeContainerView((EObject)element);
        } else if (element instanceof DNodeListElement) {
            DiagramServices.getDiagramServices().removeNodeListElementView((AbstractDNode)((DNodeListElement)element));
        } else if (element instanceof DNode) {
            DiagramServices.getDiagramServices().removeNodeView((DNode)element);
        }
    }

    public static void checkIsSynchronized(DDiagram diagram) {
        boolean isSynchronized = diagram.isSynchronized();
        Assert.assertTrue((String)MessageFormat.format(Messages.failedIsSynchronized, diagram.getName()), (boolean)isSynchronized);
    }

    public static void checkIsUnSynchronized(DDiagram diagram) {
        boolean isUnSynchronized = !diagram.isSynchronized();
        Assert.assertTrue((String)MessageFormat.format(Messages.failedIsUnSynchronized, diagram.getName()), (boolean)isUnSynchronized);
    }

    public static List<DDiagramElement> getVisibleDiagramElements(DDiagram diagram) {
        ArrayList<DDiagramElement> result = new ArrayList<DDiagramElement>();
        EList diagramElements = diagram.getDiagramElements();
        for (DDiagramElement currentElement : diagramElements) {
            if (!currentElement.isVisible()) continue;
            result.add(currentElement);
        }
        return result;
    }

    public static List<DDiagramElement> getInvisibleDiagramElements(DDiagram diagram) {
        ArrayList<DDiagramElement> result = new ArrayList<DDiagramElement>();
        EList diagramElements = diagram.getDiagramElements();
        for (DDiagramElement currentElement : diagramElements) {
            if (currentElement.isVisible()) continue;
            result.add(currentElement);
        }
        return result;
    }

    public static ShapeStyle getNote(DDiagram diagram, String description) {
        TreeIterator eAllContents;
        EList ownedAnnotationEntries = diagram.getOwnedAnnotationEntries();
        AnnotationEntry annotationEntry = (AnnotationEntry)ownedAnnotationEntries.get(0);
        EObject data = annotationEntry.getData();
        Assert.assertTrue((boolean)(data instanceof Diagram));
        Diagram diag = (Diagram)data;
        TreeIterator persistedChildren = eAllContents = diag.eAllContents();
        while (persistedChildren.hasNext()) {
            Shape note;
            EObject next = (EObject)persistedChildren.next();
            if (next instanceof Shape && (note = (Shape)next).getDescription().equalsIgnoreCase(description)) {
                return note;
            }
            if (!(next instanceof ShapeStyle) || !(note = (ShapeStyle)next).getDescription().equalsIgnoreCase(description)) continue;
            return note;
        }
        return null;
    }

    public static List<ShapeStyle> getDiagramNotes(DDiagram diagram) {
        TreeIterator eAllContents;
        ArrayList<ShapeStyle> resultList = new ArrayList<ShapeStyle>();
        EList ownedAnnotationEntries = diagram.getOwnedAnnotationEntries();
        AnnotationEntry annotationEntry = null;
        for (AnnotationEntry entry : ownedAnnotationEntries) {
            if (!"GMF_DIAGRAMS".equals(entry.getSource())) continue;
            annotationEntry = entry;
        }
        EObject data = annotationEntry.getData();
        Assert.assertTrue((boolean)(data instanceof Diagram));
        Diagram diag = (Diagram)data;
        TreeIterator persistedChildren = eAllContents = diag.eAllContents();
        while (persistedChildren.hasNext()) {
            Shape note;
            EObject next = (EObject)persistedChildren.next();
            if (next instanceof Shape && (note = (Shape)next).getType().equals("note")) {
                resultList.add((ShapeStyle)note);
            }
            if (!(next instanceof ShapeStyle) || (note = (ShapeStyle)next).getDescription().equals("")) continue;
            resultList.add((ShapeStyle)note);
        }
        return resultList;
    }

    public static List<Edge> getDiagramNoteAttachments(DDiagram diagram) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        EList ownedAnnotationEntries = diagram.getOwnedAnnotationEntries();
        AnnotationEntry annotationEntry = (AnnotationEntry)ownedAnnotationEntries.get(0);
        EObject data = annotationEntry.getData();
        Assert.assertTrue((boolean)(data instanceof Diagram));
        Diagram diag = (Diagram)data;
        EList edges = diag.getPersistedEdges();
        for (Object element : edges) {
            Edge currentEdge;
            if (!(element instanceof Edge) || !(currentEdge = (Edge)element).getType().equals("NoteAttachment")) continue;
            result.add(currentEdge);
        }
        return result;
    }

    public static void checkDiagramContextualElements(DDiagram diagram, List<EObject> expectedContextualElementsList) {
        boolean hasContextualElements = ContextualDiagramHelper.getService().hasContextualElements((DRepresentation)diagram);
        Assert.assertTrue((String)MessageFormat.format(Messages.noContextualElement, diagram.getName()), (boolean)hasContextualElements);
        List contextualElements = ContextualDiagramHelper.getService().getContextualElements((DRepresentation)diagram);
        int expectedNumberOfContextualElements = expectedContextualElementsList.size();
        boolean sameSize = contextualElements.size() == expectedNumberOfContextualElements;
        Assert.assertTrue((String)MessageFormat.format(Messages.wrongNumberOfContextualElement, diagram.getName(), contextualElements.size(), expectedNumberOfContextualElements), (boolean)sameSize);
        boolean sameElements = contextualElements.containsAll(expectedContextualElementsList) && expectedContextualElementsList.containsAll(contextualElements);
        Assert.assertTrue((String)Messages.wrongContextualElement, (boolean)sameElements);
    }

    public static Diagram getDiagram(DDiagram seqDiagram) {
        EList ownedAnnotationEntries = seqDiagram.getOwnedAnnotationEntries();
        EObject data = null;
        for (AnnotationEntry annotationEntry : ownedAnnotationEntries) {
            if (annotationEntry == null || !(annotationEntry.getData() instanceof Diagram)) continue;
            data = annotationEntry.getData();
        }
        Assert.assertTrue((boolean)(data instanceof Diagram));
        Diagram diagram = (Diagram)data;
        return diagram;
    }

    public static boolean isDiagramElementFiltered(DDiagramElement element) {
        return new DDiagramElementQuery(element).isFiltered() || new DDiagramElementQuery(element).isIndirectlyFiltered();
    }

    public static FilterDescription getFilterForDiagram(DDiagram diagram, String filterName) {
        DiagramDescription description = diagram.getDescription();
        EList filters = description.getFilters();
        for (FilterDescription filter : filters) {
            if (!filter.getName().equalsIgnoreCase(filterName)) continue;
            return filter;
        }
        return null;
    }

    public static void addFilterInDiagram(final DDiagram diagram, final FilterDescription filter) {
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                EList activatedFilters = diagram.getActivatedFilters();
                activatedFilters.add((Object)filter);
                CompositeFilterApplicationBuilder builder = new CompositeFilterApplicationBuilder(diagram);
                builder.computeCompositeFilterApplications();
                DialectManager.INSTANCE.refresh((DRepresentation)diagram, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        TestHelper.getExecutionManager((EObject)diagram).execute((ICommand)cmd);
    }

    @Deprecated
    public static void assertCheckObjectOnDiagram(DDiagram diagram, List<EObject> list, boolean shouldBeAvailable) {
        DDiagramElement eObject = null;
        String errMsg = shouldBeAvailable ? CommonTestMessages.objectRepresentationNotAvailableOnDiagram : CommonTestMessages.objectRepresentationStillAvailableOnDiagram;
        for (EObject current : list) {
            eObject = DiagramHelper.getOnDiagram(diagram, current);
            Assert.assertTrue((String)NLS.bind((String)errMsg, (Object[])new Object[]{current instanceof AbstractNamedElement ? ((AbstractNamedElement)current).getName() : current.eClass().getName(), diagram.getName()}), (boolean)(shouldBeAvailable ? eObject != null : eObject == null));
        }
    }

    public static void isOnDiagram(DDiagram diagram, List<EObject> list, boolean shouldBeAvailable) {
        DDiagramElement eObject = null;
        String errMsg = shouldBeAvailable ? CommonTestMessages.objectRepresentationNotAvailableOnDiagram : CommonTestMessages.objectRepresentationStillAvailableOnDiagram;
        for (EObject current : list) {
            eObject = DiagramHelper.getOnDiagram(diagram, current);
            Assert.assertTrue((String)NLS.bind((String)errMsg, (Object[])new Object[]{current instanceof AbstractNamedElement ? ((AbstractNamedElement)current).getName() : current.eClass().getName(), diagram.getName()}), (boolean)(shouldBeAvailable ? eObject != null : eObject == null));
        }
    }

    public static Collection<DDiagramElement> getOwnedElements(DSemanticDecorator element) {
        if (element instanceof DDiagram) {
            return new ArrayList<DDiagramElement>((Collection<DDiagramElement>)((DDiagram)element).getOwnedDiagramElements());
        }
        if (element instanceof AbstractDNode) {
            return DiagramServices.getDiagramServices().getOwnedAbstractNodes(element);
        }
        return Collections.emptyList();
    }

    public static List<DEdge> getEdges(DDiagram diagram, String elementId) {
        ArrayList<DEdge> edgeList = new ArrayList<DEdge>();
        for (DDiagramElement element : diagram.getDiagramElements()) {
            if (!(element instanceof DEdge) || !(element.getTarget() instanceof ModelElement) || !((ModelElement)element.getTarget()).getId().equals(elementId)) continue;
            edgeList.add((DEdge)element);
        }
        return edgeList;
    }
}

