/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.wrapper.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.sequence.description.tool.MessageCreationTool;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;
import org.junit.Assert;

public class ToolHelper {
    Session _session;
    DDiagram _diagram;

    public ToolHelper(Session session, DDiagram diagram) {
        this._session = session;
        this._diagram = diagram;
    }

    public AbstractToolDescription getTool(String toolName) {
        Assert.assertNotNull((Object)this._session);
        Assert.assertNotNull((Object)this._diagram);
        EList tools = new DiagramComponentizationManager().getAllTools(this._session.getSelectedViewpoints(true), this._diagram.getDescription());
        AbstractToolDescription theAbstractToolDescription = null;
        for (AbstractToolDescription current : tools) {
            if (!current.getName().equals(toolName)) continue;
            theAbstractToolDescription = current;
            break;
        }
        return theAbstractToolDescription;
    }

    public AbstractToolDescription getToolByLabel(String toolName) {
        Assert.assertNotNull((Object)this._session);
        Assert.assertNotNull((Object)this._diagram);
        EList tools = new DiagramComponentizationManager().getAllTools(this._session.getSelectedViewpoints(true), this._diagram.getDescription());
        AbstractToolDescription theAbstractToolDescription = null;
        for (AbstractToolDescription current : tools) {
            if (current.getLabel() == null || !current.getLabel().equals(toolName)) continue;
            theAbstractToolDescription = current;
            break;
        }
        return theAbstractToolDescription;
    }

    public AbstractToolDescription getToolByLabel(String toolName, String toolLabel) {
        Assert.assertNotNull((Object)this._session);
        Assert.assertNotNull((Object)this._diagram);
        EList tools = new DiagramComponentizationManager().getAllTools(this._session.getSelectedViewpoints(true), this._diagram.getDescription());
        AbstractToolDescription theAbstractToolDescription = null;
        for (AbstractToolDescription current : tools) {
            if (!current.getName().equals(toolName) || current.getLabel() == null || !current.getLabel().equals(toolLabel)) continue;
            theAbstractToolDescription = current;
            break;
        }
        return theAbstractToolDescription;
    }

    public static Set<String> getSetOfActualTools(EList<AbstractToolDescription> tools) {
        HashSet<String> setOfActualTools = new HashSet<String>();
        ArrayList<String> listOfDuplicated = new ArrayList<String>();
        for (AbstractToolDescription toolDescription : tools) {
            if (!(toolDescription instanceof ContainerCreationDescription) && !(toolDescription instanceof NodeCreationDescription) && !(toolDescription instanceof EdgeCreationDescription) && !(toolDescription instanceof ToolDescription) && !(toolDescription instanceof MessageCreationTool)) continue;
            if (toolDescription.getLabel() == null || toolDescription.getLabel().equalsIgnoreCase("")) {
                if (setOfActualTools.add(toolDescription.getName())) continue;
                listOfDuplicated.add(toolDescription.getName());
                continue;
            }
            if (setOfActualTools.add(toolDescription.getLabel())) continue;
            listOfDuplicated.add(toolDescription.getLabel());
        }
        return setOfActualTools;
    }

    public static Set<String> getSetOfActualToolsWithoutConstraintsAccelerators(EList<AbstractToolDescription> tools) {
        HashSet<String> setOfActualTools = new HashSet<String>();
        ArrayList<String> listOfDuplicated = new ArrayList<String>();
        for (AbstractToolDescription toolDescription : tools) {
            if (ToolHelper.getGroupTools(tools, "Constraints").contains(toolDescription) || ToolHelper.getGroupTools(tools, "Accelerators").contains(toolDescription) || !(toolDescription instanceof ContainerCreationDescription) && !(toolDescription instanceof NodeCreationDescription) && !(toolDescription instanceof EdgeCreationDescription) && !(toolDescription instanceof ToolDescription) && !(toolDescription instanceof MessageCreationTool) || setOfActualTools.add(toolDescription.getName())) continue;
            listOfDuplicated.add(toolDescription.getName());
        }
        return setOfActualTools;
    }

    private static List<AbstractToolDescription> getGroupTools(EList<AbstractToolDescription> tools, String groupName) {
        ArrayList<AbstractToolDescription> listOfGroupTools = new ArrayList<AbstractToolDescription>();
        for (AbstractToolDescription toolDescription : tools) {
            IdentifiedElement container;
            if (!(toolDescription instanceof ContainerCreationDescription) && !(toolDescription instanceof NodeCreationDescription) && !(toolDescription instanceof EdgeCreationDescription) && !(toolDescription instanceof ToolDescription) && !(toolDescription instanceof MessageCreationTool) || !(toolDescription.eContainer() instanceof IdentifiedElement) || !(container = (IdentifiedElement)toolDescription.eContainer()).getName().equals(groupName)) continue;
            listOfGroupTools.add(toolDescription);
        }
        return listOfGroupTools;
    }
}

