/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.layout.ju.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.ui.tools.api.views.common.item.ItemWrapper;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.common.ui.services.commands.AbstractUiHandler;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.diagram.layout.ju.layout.DiagramLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.LayoutFactory;
import org.polarsys.capella.test.diagram.layout.ju.layout.SessionLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.compare.CompareLayoutManager;
import org.polarsys.capella.test.framework.context.SessionContext;

public class CompareLayoutHandler
extends AbstractUiHandler {
    CompareLayoutManager manager = new CompareLayoutManager();

    public CompareLayoutManager getManager() {
        return this.manager;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<DRepresentationDescriptor> diagrams = new ArrayList<DRepresentationDescriptor>();
        Object[] objectArray = ((IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event)).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selection = objectArray[n2];
            if (selection instanceof DRepresentationDescriptor) {
                diagrams.add((DRepresentationDescriptor)selection);
            } else if (selection instanceof ItemWrapper) {
                diagrams.add((DRepresentationDescriptor)((ItemWrapper)selection).getWrappedObject());
            }
            ++n2;
        }
        DRepresentationDescriptor descriptor = (DRepresentationDescriptor)diagrams.get(0);
        DRepresentationDescriptor descriptor2 = (DRepresentationDescriptor)diagrams.get(1);
        this.manager = new CompareLayoutManager();
        this.compare(descriptor, descriptor2, true);
        return null;
    }

    public void copyPasteLayout(DRepresentationDescriptor diagram1, DRepresentationDescriptor diagram2) {
        Session session = SessionManager.INSTANCE.getSession(diagram1.getTarget());
        SessionContext context = new SessionContext(session);
        DiagramContext c = new DiagramContext(context, (DDiagram)diagram1.getRepresentation());
        c.open();
        DiagramHelper.copyLayout((DDiagram)c.getDiagram());
        DiagramContext c2 = new DiagramContext(context, (DDiagram)diagram2.getRepresentation());
        c2.open();
        DiagramHelper.pasteLayout((DDiagram)c2.getDiagram());
    }

    public void compare(DRepresentationDescriptor diagram1, DRepresentationDescriptor diagram2, boolean ui) {
        Session session = SessionManager.INSTANCE.getSession(diagram1.getTarget());
        SessionLayout sessionLayout = LayoutFactory.eINSTANCE.createSessionLayout();
        DiagramLayout layout = this.manager.getCurrentLayout(session, (DDiagram)diagram1.getRepresentation());
        sessionLayout.getOwnedLayouts().add((Object)layout);
        SessionLayout sessionLayout2 = LayoutFactory.eINSTANCE.createSessionLayout();
        DiagramLayout layout2 = this.manager.getCurrentLayout(session, (DDiagram)diagram2.getRepresentation());
        sessionLayout2.getOwnedLayouts().add((Object)layout2);
        layout2.setId(layout.getId());
        layout2.setName(layout.getName());
        if (ui) {
            this.manager.uiAnalysis(sessionLayout, sessionLayout2);
        } else {
            this.manager.analysis(sessionLayout, sessionLayout2);
        }
    }
}

