/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.layout.ju.layout.compare;

import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.impl.policies.DefaultMatchPolicy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.diagram.layout.ju.layout.Bounds;
import org.polarsys.capella.test.diagram.layout.ju.layout.DiagramLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.EdgeLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.ISemanticLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.Location;
import org.polarsys.capella.test.diagram.layout.ju.layout.NodeLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.NoteLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.SessionLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.Size;

public class LayoutMatchPolicy
extends DefaultMatchPolicy {
    HashMap<String, String> match = new HashMap();
    HashMap<String, String> mappingMatch = new HashMap();

    public void addMappingMatch(String source, String target) {
        this.mappingMatch.put(target, source);
    }

    public void addMatch(EObject element1, EObject element2) {
        String id1 = IdManager.getInstance().getId(element1);
        String id2 = IdManager.getInstance().getId(element2);
        this.match.put(id2, id1);
    }

    public boolean keepMatchIDs() {
        return true;
    }

    protected String getMappingId(String mapping) {
        if (this.mappingMatch.containsKey(mapping)) {
            return this.mappingMatch.get(mapping);
        }
        return mapping;
    }

    protected String getSemanticId(ISemanticLayout layout) {
        if (this.match.containsKey(layout.getId())) {
            return this.match.get(layout.getId());
        }
        return layout.getId();
    }

    public Object getMatchID(EObject element_p, IModelScope scope_p) {
        if (element_p == null) {
            return "null";
        }
        if (element_p instanceof SessionLayout) {
            return SessionLayout.class.getSimpleName();
        }
        if (element_p instanceof NodeLayout) {
            NodeLayout layout = (NodeLayout)element_p;
            String id = (String)this.getMatchID(element_p.eContainer(), scope_p);
            id = String.valueOf(id) + " id:" + this.getSemanticId(layout);
            id = String.valueOf(id) + " mapping:" + this.getMappingId(layout.getActualMapping());
            return id;
        }
        if (element_p instanceof EdgeLayout) {
            EdgeLayout layout = (EdgeLayout)element_p;
            String id = (String)this.getMatchID(element_p.eContainer(), scope_p);
            id = String.valueOf(id) + " id:" + this.getSemanticId(layout);
            id = String.valueOf(id) + " source:" + (String)this.getMatchID((EObject)layout.getSource(), scope_p);
            id = String.valueOf(id) + " target:" + (String)this.getMatchID((EObject)layout.getTarget(), scope_p);
            id = String.valueOf(id) + " mapping:" + this.getMappingId(layout.getActualMapping());
            return id;
        }
        if (element_p instanceof DiagramLayout) {
            DiagramLayout layout = (DiagramLayout)element_p;
            return String.valueOf(this.getSemanticId(layout)) + " " + layout.getName() + " ";
        }
        if (element_p instanceof Bounds || element_p instanceof Location || element_p instanceof Size) {
            String id = (String)this.getMatchID(element_p.eContainer(), scope_p);
            id = String.valueOf(id) + "." + element_p.eContainingFeature().getName();
            if (element_p.eContainingFeature().isMany()) {
                id = String.valueOf(id) + "[" + ((EList)element_p.eContainer().eGet(element_p.eContainingFeature())).indexOf((Object)element_p) + "]";
            }
            return id;
        }
        if (element_p instanceof NoteLayout) {
            NoteLayout layout = (NoteLayout)element_p;
            String id = (String)this.getMatchID(element_p.eContainer(), scope_p);
            id = String.valueOf(id) + " id:" + this.getSemanticId(layout);
            return id;
        }
        return super.getMatchID(element_p, scope_p);
    }

    public void addMatchRPLtoREC(CatalogElement rpl) {
        for (CatalogElementLink link : rpl.getOwnedLinks()) {
            this.addMatch(link.getTarget(), link.getOrigin().getTarget());
        }
    }

    public void addArchitectureBlankMappingMatches() {
        this.addMappingMatch("ACTOR", "System Actors");
        this.addMappingMatch("ACTOR", "Logical Actors");
        this.addMappingMatch("ACTOR", "PAB_Actor");
        this.addMappingMatch("FCT", "CA System Function");
        this.addMappingMatch("FCT", "LAB Logical Function");
        this.addMappingMatch("FCT", "PAB_PhysicalFunction");
        this.addMappingMatch("FP", "CA Flow Port on System Function");
        this.addMappingMatch("FP", "LAB Flow Port on Logical Function");
        this.addMappingMatch("FP", "PAB_Pin");
        this.addMappingMatch("EXC", "CA DataFlow between Function");
        this.addMappingMatch("EXC", "LAB DataFlow between Function");
        this.addMappingMatch("EXC", "PAB_FunctionExchange");
    }

    public void addMatchForTransition(BlockArchitecture architecture) {
        Predicate<AbstractTrace> fromTransition = new Predicate<AbstractTrace>(){

            @Override
            public boolean test(AbstractTrace trace) {
                BlockArchitecture s = BlockArchitectureExt.getRootBlockArchitecture((EObject)trace.getSourceElement());
                BlockArchitecture t = BlockArchitectureExt.getRootBlockArchitecture((EObject)trace.getTargetElement());
                return s.getAllocatedArchitectures().contains((Object)t);
            }
        };
        TreeIterator objects = EcoreUtil.getAllContents((EObject)architecture, (boolean)false);
        while (objects.hasNext()) {
            List p;
            EObject object = (EObject)objects.next();
            if (!(object instanceof TraceableElement) || (p = ((TraceableElement)object).getOutgoingTraces().stream().filter(fromTransition).collect(Collectors.toList())).isEmpty()) continue;
            this.addMatch(object, (EObject)((AbstractTrace)p.get(0)).getTargetElement());
            if (!(object instanceof Component)) continue;
            this.addMatch((EObject)((Component)object).getRepresentingPartitions().get(0), (EObject)((Component)((AbstractTrace)p.get(0)).getTargetElement()).getRepresentingPartitions().get(0));
        }
    }
}

