/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.lab;

import junit.framework.Test;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.test.diagram.common.ju.context.CDBDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.tools.RenameTool;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ToolHelper;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class ConstraintRenameTestCase
extends EmptyProject {
    public static String LAB_DIAGRAM = "[LAB] Logical System - Logical Architecture Blank";
    public static String RENAME_CONSTRAINT_TOOL = "Constraint Content";
    public static String NEW_NAME = "New Constraint";

    public void test() throws Exception {
        final Session session = this.getSessionForTestModel(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        XABDiagram xabDiagram = XABDiagram.createDiagram((SessionContext)context, (String)"32f06455-48c7-4d68-aea5-cf397ab4aff2");
        final CDBDiagram cdbDiagram = CDBDiagram.createDiagram((SessionContext)context, (String)"7474ef84-8450-4e03-9ba6-0674ce0b0dbd");
        ToolHelper toolhelper = new ToolHelper(session, cdbDiagram.getDiagram());
        AbstractToolDescription tool = toolhelper.getTool(RENAME_CONSTRAINT_TOOL);
        ConstraintRenameTestCase.assertTrue((String)"Rename tool has not been found", (tool != null && tool instanceof DirectEditLabel ? 1 : 0) != 0);
        DirectEditLabel renameTool = (DirectEditLabel)tool;
        ConstraintRenameTestCase.assertTrue((String)"Constraint's name should be displayed when rename tool is applied", (renameTool.getInputLabelExpression() != null && renameTool.getInputLabelExpression().equals("feature:name") ? 1 : 0) != 0);
        xabDiagram.createConstraint(GenericModel.CONSTRAINT_1);
        Constraint constraint = (Constraint)xabDiagram.getSemanticElement(GenericModel.CONSTRAINT_1);
        new RenameTool((DiagramContext)xabDiagram, RENAME_CONSTRAINT_TOOL, (EObject)constraint, NEW_NAME){

            protected AbstractToolDescription getRenameTool() {
                ToolHelper toolhelper = new ToolHelper(session, cdbDiagram.getDiagram());
                AbstractToolDescription tool = toolhelper.getTool(RENAME_CONSTRAINT_TOOL);
                return tool;
            }
        }.run();
        ConstraintRenameTestCase.assertTrue((String)"The constraint has not been renamed", (boolean)constraint.getName().equals(NEW_NAME));
    }

    public static Test suite() {
        return new ConstraintRenameTestCase();
    }
}

