/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.msm;

import junit.framework.Test;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.DragAndDropTool;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class MSMDragAndDropStates
extends EmptyProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        DiagramContext diagramContext = (DiagramContext)new CreateDiagramStep(context, "555fc1d5-1910-4d77-8158-9302240fe0ca", "Modes & States").run();
        new OpenDiagramStep(diagramContext).run();
        new CreateContainerTool(diagramContext, "State", diagramContext.getDiagramId(), GenericModel.STATE_1).run();
        new CreateContainerTool(diagramContext, "State", diagramContext.getDiagramId(), GenericModel.STATE_2).run();
        new DragAndDropTool(diagramContext, "D&D ModeState from Diagram", GenericModel.STATE_1, GenericModel.STATE_2).run();
        Region region = (Region)context.getSemanticElement("555fc1d5-1910-4d77-8158-9302240fe0ca");
        State state1 = (State)context.getSemanticElement(GenericModel.STATE_1);
        State state2 = (State)context.getSemanticElement(GenericModel.STATE_2);
        MSMDragAndDropStates.assertTrue((boolean)region.getOwnedStates().contains((Object)state2));
        MSMDragAndDropStates.assertTrue((String)"Default Region should not contain State1", (!region.getOwnedStates().contains((Object)state1) ? 1 : 0) != 0);
        MSMDragAndDropStates.assertTrue((boolean)region.getInvolvedStates().contains((Object)state2));
        MSMDragAndDropStates.assertTrue((String)"Default Region should not involve State1", (!region.getInvolvedStates().contains((Object)state1) ? 1 : 0) != 0);
        MSMDragAndDropStates.assertTrue((boolean)((Region)state2.getOwnedRegions().get(0)).getInvolvedStates().contains((Object)state1));
        MSMDragAndDropStates.assertTrue((String)"State2 should involve State1", (!region.getInvolvedStates().contains((Object)state1) ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new MSMDragAndDropStates();
    }
}

