/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.msm;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.MSMDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.filters.FilterStep;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class MSMHideRegionNamesFilterTest
extends EmptyProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        MSMDiagram diagram = MSMDiagram.createDiagram((SessionContext)context, (String)"555fc1d5-1910-4d77-8158-9302240fe0ca");
        diagram.createState(diagram.getDiagramId(), GenericModel.STATE_1);
        diagram.createRegion(GenericModel.STATE_1, GenericModel.REGION_1);
        diagram.createRegion(GenericModel.STATE_1, GenericModel.REGION_2);
        diagram.createState(GenericModel.REGION_1, GenericModel.STATE_2);
        diagram.createRegion(GenericModel.STATE_2, GenericModel.REGION_3);
        diagram.createRegion(GenericModel.STATE_2, GenericModel.REGION_4);
        State state1 = (State)diagram.getSemanticElement(GenericModel.STATE_1);
        EList regions1 = state1.getOwnedRegions();
        MSMHideRegionNamesFilterTest.assertEquals((String)"State 1 must have 3 regions", (int)3, (int)regions1.size());
        DDiagramElement region1_1 = diagram.getView((EObject)regions1.get(0));
        DDiagramElement region1_2 = diagram.getView((EObject)regions1.get(1));
        DDiagramElement region1_3 = diagram.getView((EObject)regions1.get(2));
        State state2 = (State)diagram.getSemanticElement(GenericModel.STATE_1);
        EList regions2 = state2.getOwnedRegions();
        MSMHideRegionNamesFilterTest.assertEquals((String)"State 2 must have 3 regions", (int)3, (int)regions2.size());
        DDiagramElement region2_1 = diagram.getView((EObject)regions2.get(0));
        DDiagramElement region2_2 = diagram.getView((EObject)regions2.get(1));
        DDiagramElement region2_3 = diagram.getView((EObject)regions2.get(2));
        MSMHideRegionNamesFilterTest.assertEquals((String)" [Region 3]", (String)region1_1.getName());
        MSMHideRegionNamesFilterTest.assertEquals((String)" [Region 2]", (String)region1_2.getName());
        MSMHideRegionNamesFilterTest.assertEquals((String)" [region]", (String)region1_3.getName());
        MSMHideRegionNamesFilterTest.assertEquals((String)" [Region 3]", (String)region2_1.getName());
        MSMHideRegionNamesFilterTest.assertEquals((String)" [Region 2]", (String)region2_2.getName());
        MSMHideRegionNamesFilterTest.assertEquals((String)" [region]", (String)region2_3.getName());
        FilterStep filter = new FilterStep((DiagramContext)diagram, "HideRegionNames");
        filter.activate(new String[0]);
        MSMHideRegionNamesFilterTest.assertEquals((String)"", (String)region1_1.getName());
        MSMHideRegionNamesFilterTest.assertEquals((String)"", (String)region1_2.getName());
        MSMHideRegionNamesFilterTest.assertEquals((String)"", (String)region1_3.getName());
        MSMHideRegionNamesFilterTest.assertEquals((String)"", (String)region2_1.getName());
        MSMHideRegionNamesFilterTest.assertEquals((String)"", (String)region2_2.getName());
        MSMHideRegionNamesFilterTest.assertEquals((String)"", (String)region2_3.getName());
    }
}

