/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.pab;

import java.util.List;
import junit.framework.Test;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.polarsys.capella.test.diagram.common.ju.api.AbstractDiagramTestCase;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.DeleteElementTool;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.context.SessionContext;

public class DeleteConstraintLinkTestCase
extends AbstractDiagramTestCase {
    public static String CONSTRAINT_LINK = "4e13c35a-a2f6-48fa-9e96-cf24ac1b1b61";
    public static String PAB_DIAGRAM = "[PAB] Physical System - Physical Architecture Blank";
    public static String CDB_DIAGRAM = "[CDB] Data - Class Diagram Blank";

    public void test() throws Exception {
        Session session = this.getSessionForTestModel(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        DiagramContext diagramContext = (DiagramContext)new OpenDiagramStep(context, PAB_DIAGRAM).run();
        DiagramContext cdbDiagramContext = (DiagramContext)new OpenDiagramStep(context, CDB_DIAGRAM).run();
        List edgeList = DiagramHelper.getEdges((DDiagram)diagramContext.getDiagram(), (String)CONSTRAINT_LINK);
        for (DEdge edge : edgeList) {
            new DeleteElementTool(diagramContext, cdbDiagramContext, "Delete Constraint Elements").delete((DDiagramElement)edge);
        }
        edgeList = DiagramHelper.getEdges((DDiagram)diagramContext.getDiagram(), (String)CONSTRAINT_LINK);
        DeleteConstraintLinkTestCase.assertTrue((String)"Constraint link is not removed from the diagram after a deletion", (edgeList.size() == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new DeleteConstraintLinkTestCase();
    }

    protected String getRequiredTestModel() {
        return "PABDiagramModel";
    }
}

