/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.pd;

import junit.framework.Test;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.diagram.tools.ju.model.CDBCommunication;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class CreateDependencies
extends CDBCommunication {
    private static final String DATAPKG_1 = "1";
    private static final String DATAPKG_1_1 = "1_1";
    private static final String DATAPKG_2 = "2";
    private static final String DATAPKG_2_1 = "2_1";
    private static final String DATAPKG_3 = "3";
    private static final String DATAPKG_3_1 = "3_1";
    private static final String TOOL_CDB_CREATE_DATA_PACKAGE = "DataPkg";

    private void setName(ExecutionManager executionManager, NamedElement object, String newName) {
        final String finalNewName = newName;
        final NamedElement finalObject = object;
        executionManager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                finalObject.setName(finalNewName);
            }
        });
    }

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        DiagramContext diagramContext = (DiagramContext)new CreateDiagramStep(context, SA__DATAPKG, "Class Diagram Blank").run();
        new OpenDiagramStep(diagramContext).run();
        DDiagramElementContainer diagramElement = (DDiagramElementContainer)new CreateAbstractDNodeTool(diagramContext, TOOL_CDB_CREATE_DATA_PACKAGE, diagramContext.getDiagramId(), DATAPKG_1, DDiagramElementContainer.class).run();
        ExecutionManager executionManager = TransactionHelper.getExecutionManager((EObject)diagramElement.getTarget());
        this.setName(executionManager, (NamedElement)diagramElement.getTarget(), DATAPKG_1);
        diagramElement = (DDiagramElementContainer)new CreateAbstractDNodeTool(diagramContext, "Class", DATAPKG_1, GenericModel.CLASS_4, DDiagramElementContainer.class).run();
        this.setName(executionManager, (NamedElement)diagramElement.getTarget(), GenericModel.CLASS_4);
        diagramElement = (DDiagramElementContainer)new CreateAbstractDNodeTool(diagramContext, TOOL_CDB_CREATE_DATA_PACKAGE, DATAPKG_1, DATAPKG_1_1, DDiagramElementContainer.class).run();
        this.setName(executionManager, (NamedElement)diagramElement.getTarget(), DATAPKG_1_1);
        diagramElement = (DDiagramElementContainer)new CreateAbstractDNodeTool(diagramContext, "Class", DATAPKG_1_1, GenericModel.CLASS_1, DDiagramElementContainer.class).run();
        this.setName(executionManager, (NamedElement)diagramElement.getTarget(), GenericModel.CLASS_1);
        diagramElement = (DDiagramElementContainer)new CreateAbstractDNodeTool(diagramContext, TOOL_CDB_CREATE_DATA_PACKAGE, diagramContext.getDiagramId(), DATAPKG_2, DDiagramElementContainer.class).run();
        this.setName(executionManager, (NamedElement)diagramElement.getTarget(), DATAPKG_2);
        diagramElement = (DDiagramElementContainer)new CreateAbstractDNodeTool(diagramContext, TOOL_CDB_CREATE_DATA_PACKAGE, DATAPKG_2, DATAPKG_2_1, DDiagramElementContainer.class).run();
        this.setName(executionManager, (NamedElement)diagramElement.getTarget(), DATAPKG_2_1);
        diagramElement = (DDiagramElementContainer)new CreateAbstractDNodeTool(diagramContext, "Class", DATAPKG_2_1, GenericModel.CLASS_2, DDiagramElementContainer.class).run();
        this.setName(executionManager, (NamedElement)diagramElement.getTarget(), GenericModel.CLASS_2);
        diagramElement = (DDiagramElementContainer)new CreateAbstractDNodeTool(diagramContext, TOOL_CDB_CREATE_DATA_PACKAGE, diagramContext.getDiagramId(), DATAPKG_3, DDiagramElementContainer.class).run();
        this.setName(executionManager, (NamedElement)diagramElement.getTarget(), DATAPKG_3);
        diagramElement = (DDiagramElementContainer)new CreateAbstractDNodeTool(diagramContext, TOOL_CDB_CREATE_DATA_PACKAGE, DATAPKG_3, DATAPKG_3_1, DDiagramElementContainer.class).run();
        this.setName(executionManager, (NamedElement)diagramElement.getTarget(), DATAPKG_3_1);
        diagramElement = (DDiagramElementContainer)new CreateAbstractDNodeTool(diagramContext, "Class", DATAPKG_3_1, GenericModel.CLASS_3, DDiagramElementContainer.class).run();
        this.setName(executionManager, (NamedElement)diagramElement.getTarget(), GenericModel.CLASS_3);
        new CreateEdgeTool(diagramContext, "Association", "ASSOC 1", GenericModel.CLASS_3, GenericModel.CLASS_2, 1).run();
        new CreateEdgeTool(diagramContext, "Association", "ASSOC 2", GenericModel.CLASS_3, GenericModel.CLASS_1, 1).run();
        new CreateEdgeTool(diagramContext, "Association", "ASSOC 3", GenericModel.CLASS_2, GenericModel.CLASS_1, 1).run();
        new CreateEdgeTool(diagramContext, "Association", "ASSOC 4", GenericModel.CLASS_4, GenericModel.CLASS_1, 1).run();
        DDiagram classDiagram = diagramContext.getDiagram();
        CreateDependencies.assertEquals((String)"Wrong number of DiagramElements in the Class Diagram", (int)14, (int)classDiagram.getDiagramElements().size());
        DiagramContext pdDiagramContext = (DiagramContext)new CreateDiagramStep(context, DATAPKG_1, "Package Dependencies").run();
        new OpenDiagramStep(pdDiagramContext).run();
        new InsertRemoveTool(pdDiagramContext, "Show/Hide DataPkgs").insert(new String[]{DATAPKG_1, DATAPKG_2, DATAPKG_3});
        DDiagram dependenciesDiagram = pdDiagramContext.getDiagram();
        session.save((IProgressMonitor)new NullProgressMonitor());
        CreateDependencies.assertEquals((String)"Wrong number of DiagramElements in the Dependencies Diagram", (int)6, (int)dependenciesDiagram.getDiagramElements().size());
        for (DDiagramElement element : dependenciesDiagram.getOwnedDiagramElements()) {
            if (!(element instanceof DEdge)) continue;
            DEdge edge = (DEdge)element;
            String sourceNodeName = ((DNodeContainer)edge.getSourceNode()).getName();
            String targetNodeName = ((DNodeContainer)edge.getTargetNode()).getName();
            CreateDependencies.assertTrue((String)("Wrong Edge created " + sourceNodeName + " -> " + targetNodeName), (DATAPKG_3.equals(sourceNodeName) && DATAPKG_2.equals(targetNodeName) || DATAPKG_3.equals(sourceNodeName) && DATAPKG_1.equals(targetNodeName) || DATAPKG_2.equals(sourceNodeName) && DATAPKG_1.equals(targetNodeName) ? 1 : 0) != 0);
        }
    }

    public static Test suite() {
        return new CreateDependencies();
    }
}

