/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.LineStyle;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.polarsys.capella.test.diagram.common.ju.context.PABDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.XDFBDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class ShowHideFunctions
extends EmptyProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOn(context, "6575a08a-df1a-4f94-9ef1-81029c29c5da", "bba24bed-20cd-4d6e-b981-12de37a4926d");
        this.testOn(context, "c88d639e-8bc5-4bc4-bcbd-46ce26d7a64d", "32f06455-48c7-4d68-aea5-cf397ab4aff2");
        this.testOn(context, "dc79c9ef-cb81-4b2d-b9dc-0e1603cbfaba", "16953dc7-be25-45ef-9da9-32869d0cb53f");
    }

    protected void testOn(SessionContext context, String rootSF, String rootCPS) {
        this.initialize(context, rootSF, rootCPS);
        this.testLeafFunctionInComponent(context, rootSF, rootCPS);
        this.testLeafFunctionInParentComponent(context, rootSF, rootCPS);
        this.testParentFunctionInComponent(context, rootSF, rootCPS);
        this.testParentFunctionInParentComponent(context, rootSF, rootCPS);
        this.testFunctionsMustHideIfShowSubComponent(context, rootSF, rootCPS);
    }

    protected void initialize(SessionContext context, String rootSF, String rootCPS) {
        XDFBDiagram xdfb = XDFBDiagram.createDiagram((SessionContext)context, (String)rootSF);
        xdfb.createFunction(GenericModel.FUNCTION_1);
        xdfb.createFunction(GenericModel.FUNCTION_1_1, GenericModel.FUNCTION_1);
        xdfb.createFunction(GenericModel.FUNCTION_1_1_1, GenericModel.FUNCTION_1_1);
        xdfb.createFunction(GenericModel.FUNCTION_1_1_2, GenericModel.FUNCTION_1_1);
        xdfb.createFunction(GenericModel.FUNCTION_1_2, GenericModel.FUNCTION_1);
        XABDiagram xab = XABDiagram.createDiagram((SessionContext)context, (String)rootCPS);
        xab.clearDiagram();
        this.createComponent(xab, GenericModel.COMPONENT_1, xab.getDiagramId());
        this.createComponent(xab, GenericModel.COMPONENT_1_1, GenericModel.COMPONENT_1);
        this.createComponent(xab, GenericModel.COMPONENT_1_1_1, GenericModel.COMPONENT_1_1);
        this.createComponent(xab, GenericModel.COMPONENT_1_2, GenericModel.COMPONENT_1);
        xab.manageAllocatedFunction(GenericModel.FUNCTION_1_1_1, GenericModel.COMPONENT_1_1_1);
        xab.manageAllocatedFunction(GenericModel.FUNCTION_1_1_2, GenericModel.COMPONENT_1_1_1);
        xab.manageAllocatedFunction(GenericModel.FUNCTION_1_2, GenericModel.COMPONENT_1_2);
    }

    private void createComponent(XABDiagram xab, String id, String containerId) {
        if (xab instanceof PABDiagram) {
            ((PABDiagram)xab).createBehaviorComponent(id, containerId);
        } else {
            xab.createComponent(id, containerId);
        }
    }

    private void insertComponent(XABDiagram xab, String id, String containerId) {
        if (xab instanceof PABDiagram) {
            ((PABDiagram)xab).insertBehaviorComponent(id, containerId);
        } else {
            xab.insertComponent(id, containerId);
        }
    }

    private void removeComponent(XABDiagram xab, String id, String containerId) {
        if (xab instanceof PABDiagram) {
            ((PABDiagram)xab).removeBehaviorComponent(id, containerId);
        } else {
            xab.removeComponent(id, containerId);
        }
    }

    private XABDiagram setUpDiagram(SessionContext context, String rootSF, String rootCPS) {
        XABDiagram xab = XABDiagram.createDiagram((SessionContext)context, (String)rootCPS);
        xab.clearDiagram();
        this.insertComponent(xab, GenericModel.COMPONENT_1, xab.getDiagramId());
        this.insertComponent(xab, GenericModel.COMPONENT_1_1, GenericModel.COMPONENT_1);
        this.insertComponent(xab, GenericModel.COMPONENT_1_1_1, GenericModel.COMPONENT_1_1);
        this.insertComponent(xab, GenericModel.COMPONENT_1_2, GenericModel.COMPONENT_1);
        return xab;
    }

    private void testLeafFunctionInComponent(SessionContext context, String rootSF, String rootCPS) {
        XABDiagram xab = this.setUpDiagram(context, rootSF, rootCPS);
        xab.hasntView(GenericModel.FUNCTION_1_1_1);
        xab.hasntView(GenericModel.FUNCTION_1_1_2);
        xab.hasntView(GenericModel.FUNCTION_1_2);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1_1, GenericModel.COMPONENT_1_1_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1_2, GenericModel.COMPONENT_1_1_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_2, GenericModel.COMPONENT_1_2);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1_1, false, false);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1_2, false, false);
        this.checkFunction(xab, GenericModel.FUNCTION_1_2, false, false);
    }

    private void testLeafFunctionInParentComponent(SessionContext context, String rootSF, String rootCPS) {
        XABDiagram xab = this.setUpDiagram(context, rootSF, rootCPS);
        this.removeComponent(xab, GenericModel.COMPONENT_1_1_1, GenericModel.COMPONENT_1_1);
        xab.hasntView(GenericModel.FUNCTION_1_1_1);
        xab.hasntView(GenericModel.FUNCTION_1_1_2);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1_1, GenericModel.COMPONENT_1_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1_2, GenericModel.COMPONENT_1_1);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1_1, false, true);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1_2, false, true);
        this.removeComponent(xab, GenericModel.COMPONENT_1_1, GenericModel.COMPONENT_1);
        this.removeComponent(xab, GenericModel.COMPONENT_1_2, GenericModel.COMPONENT_1);
        xab.hasntView(GenericModel.FUNCTION_1_1_1);
        xab.hasntView(GenericModel.FUNCTION_1_1_2);
        xab.hasntView(GenericModel.FUNCTION_1_2);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1_1, GenericModel.COMPONENT_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1_2, GenericModel.COMPONENT_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_2, GenericModel.COMPONENT_1);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1_1, false, true);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1_2, false, true);
        this.checkFunction(xab, GenericModel.FUNCTION_1_2, false, true);
    }

    private void testParentFunctionInComponent(SessionContext context, String rootSF, String rootCPS) {
        XABDiagram xab = this.setUpDiagram(context, rootSF, rootCPS);
        xab.hasntView(GenericModel.FUNCTION_1_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1, GenericModel.COMPONENT_1_1_1);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1, true, false);
    }

    private void testParentFunctionInParentComponent(SessionContext context, String rootSF, String rootCPS) {
        XABDiagram xab = this.setUpDiagram(context, rootSF, rootCPS);
        this.removeComponent(xab, GenericModel.COMPONENT_1_1_1, GenericModel.COMPONENT_1_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1, GenericModel.COMPONENT_1_1);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1, true, true);
        this.removeComponent(xab, GenericModel.COMPONENT_1_1, GenericModel.COMPONENT_1);
        xab.hasntView(GenericModel.FUNCTION_1_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1, GenericModel.COMPONENT_1);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1, true, true);
    }

    private void testFunctionsMustHideIfShowSubComponent(SessionContext context, String rootSF, String rootCPS) {
        XABDiagram xab = this.setUpDiagram(context, rootSF, rootCPS);
        this.removeComponent(xab, GenericModel.COMPONENT_1_2, GenericModel.COMPONENT_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_2, GenericModel.COMPONENT_1);
        this.insertComponent(xab, GenericModel.COMPONENT_1_2, GenericModel.COMPONENT_1);
        xab.hasntView(GenericModel.FUNCTION_1_2);
    }

    private void checkFunction(XABDiagram xab, String id, boolean mustBeItalic, boolean mustBeDash) {
        DSemanticDecorator view = xab.getView(id);
        if (view instanceof DNode) {
            DNode node = (DNode)view;
            NodeStyle style = node.getOwnedStyle();
            LineStyle lineStyle = style.getBorderLineStyle();
            boolean isDash = "dash".equals(lineStyle.getLiteral());
            ShowHideFunctions.assertEquals((boolean)mustBeDash, (boolean)isDash);
            boolean isItalic = false;
            EList labelFormat = style.getLabelFormat();
            for (FontFormat format : labelFormat) {
                if (!"italic".equals(format.getLiteral())) continue;
                isItalic = true;
            }
            ShowHideFunctions.assertEquals((boolean)mustBeItalic, (boolean)isItalic);
        } else {
            ShowHideFunctions.fail();
        }
    }
}

