/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xdfb;

import junit.framework.Test;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.test.diagram.common.ju.context.XDFBDiagram;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.diagram.layout.ju.layout.compare.ShapeHelper;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class XDFBShowHideFunctionalExchange
extends EmptyProject {
    public static String FE1 = "FE1";
    public static String FE2 = "FE2";

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnXDFBDiagram(context, "f875adac-b475-4f56-8ef5-0f7d3cc43347");
        this.testOnXDFBDiagram(context, "c88d639e-8bc5-4bc4-bcbd-46ce26d7a64d");
        this.testOnXDFBDiagram(context, "dc79c9ef-cb81-4b2d-b9dc-0e1603cbfaba");
    }

    protected void testOnXDFBDiagram(SessionContext context, String idSource) {
        XDFBDiagram xdfb = XDFBDiagram.createDiagram((SessionContext)context, (String)idSource);
        Diagram diagram = DiagramHelper.getDiagram((DDiagram)xdfb.getDiagram());
        xdfb.createFunction(GenericModel.FUNCTION_1);
        xdfb.createFunction(GenericModel.FUNCTION_1_1, GenericModel.FUNCTION_1);
        xdfb.createFunction(GenericModel.FUNCTION_1_2, GenericModel.FUNCTION_1);
        xdfb.createFunctionalExchange(FE1, GenericModel.FUNCTION_1_1, GenericModel.FUNCTION_1_2);
        xdfb.createFunctionalExchange(FE2, GenericModel.FUNCTION_1_2, GenericModel.FUNCTION_1_1);
        DSemanticDecorator FE2view = xdfb.getView(FE2);
        if (FE2view instanceof DEdge) {
            DEdge fe2Edge = (DEdge)FE2view;
            PointList pointList = ShapeHelper.getRelativePointListForDEdge((Diagram)diagram, (DDiagramElement)fe2Edge);
            Point firstPoint = pointList.getFirstPoint();
            Point lastPoint = pointList.getLastPoint();
            xdfb.insertFunctionalExchange(GenericModel.FUNCTION_1, FE1);
            FE2view = xdfb.getView(FE2);
            PointList pointListAfter = ShapeHelper.getRelativePointListForDEdge((Diagram)diagram, (DDiagramElement)((DEdge)FE2view));
            XDFBShowHideFunctionalExchange.assertTrue((String)"FE2 must not move if we insert FE1", (pointListAfter.getFirstPoint().getDistance(firstPoint) == 0.0 && pointListAfter.getLastPoint().getDistance(lastPoint) == 0.0 ? 1 : 0) != 0);
        } else {
            XDFBShowHideFunctionalExchange.fail((String)"FE2 must be visible and must be a DEdge");
        }
    }

    public static Test suite() {
        return new XDFBShowHideFunctionalExchange();
    }
}

