/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.libraries.ju.testcases.move;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.service.ValidationEvent;
import org.eclipse.ui.IViewPart;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.libraries.AccessPolicy;
import org.polarsys.capella.common.libraries.LibrariesFactory;
import org.polarsys.capella.common.libraries.LibraryReference;
import org.polarsys.capella.common.libraries.ModelInformation;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.libraries.model.CapellaLibraryExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.listeners.PartComponentMoveListener;
import org.polarsys.capella.core.model.skeleton.CapellaModelSkeleton;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public abstract class AbstractMoveTestCase<C extends Component>
extends BasicTestCase {
    ExecutionManager manager;
    CapellaModelSkeleton projectSkeleton;
    CapellaModelSkeleton librarySkeleton;
    IViewPart moveView;

    public void setUp() throws Exception {
        super.setUp();
        this.manager = ExecutionManagerRegistry.getInstance().addNewManager();
        this.manager.getEditingDomain().addResourceSetListener((ResourceSetListener)new PartComponentMoveListener());
        this.projectSkeleton = new CapellaModelSkeleton.Builder(this.manager).setURI(URI.createPlatformResourceURI((String)"/project/project.melodymodeller", (boolean)false)).setName("project").build();
        this.librarySkeleton = new CapellaModelSkeleton.Builder(this.manager).setURI(URI.createPlatformResourceURI((String)"/library/library.melodymodeller", (boolean)false)).setName("library").setRootType(CapellamodellerPackage.Literals.LIBRARY).build();
        final ModelInformation projectInformation = CapellaLibraryExt.getModelInformation((Resource)this.projectSkeleton.getProject().eResource(), (boolean)false);
        final ModelInformation libraryInformation = CapellaLibraryExt.getModelInformation((Resource)this.librarySkeleton.getProject().eResource(), (boolean)false);
        this.manager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                LibraryReference ref = LibrariesFactory.eINSTANCE.createLibraryReference();
                ref.setLibrary(libraryInformation);
                ref.setAccessPolicy(AccessPolicy.READ_AND_WRITE);
                projectInformation.getOwnedReferences().add((Object)ref);
            }
        });
    }

    public void tearDown() throws Exception {
        ExecutionManagerRegistry.getInstance().removeManager(this.manager);
        super.tearDown();
    }

    protected boolean executeCommand(final Runnable r) {
        AbstractReadWriteCommand arwc = new AbstractReadWriteCommand(){

            public void run() {
                r.run();
            }
        };
        this.manager.execute((ICommand)arwc);
        return !arwc.isRolledBack();
    }

    protected void expectRollback(Runnable r) {
        this.expectRollback(r, new String[0]);
    }

    protected void expectRollback(Runnable r, String ... expectedErrors) {
        final ArrayList result = new ArrayList();
        IValidationListener listener = new IValidationListener(){

            public void validationOccurred(ValidationEvent event) {
                result.addAll(event.getValidationResults());
            }
        };
        ModelValidationService.getInstance().addValidationListener(listener);
        try {
            AbstractMoveTestCase.assertFalse((boolean)this.executeCommand(r));
        }
        finally {
            ModelValidationService.getInstance().removeValidationListener(listener);
        }
        String[] stringArray = expectedErrors;
        int n = expectedErrors.length;
        int n2 = 0;
        while (n2 < n) {
            String expected = stringArray[n2];
            AbstractMoveTestCase.assertNotNull((String)("Expected validation error: " + expected), (Object)this.find(expected, result));
            ++n2;
        }
    }

    protected void expectNoRollback(Runnable r) {
        AbstractMoveTestCase.assertTrue((boolean)this.executeCommand(r));
    }

    private IStatus find(String message, Collection<? extends IStatus> status) {
        for (IStatus iStatus : status) {
            if (iStatus.isMultiStatus()) {
                IStatus result = this.find(message, Arrays.asList(iStatus.getChildren()));
                if (result == null) continue;
                return result;
            }
            System.out.println(iStatus.getMessage());
            if (!message.equals(iStatus.getMessage())) continue;
            return iStatus;
        }
        return null;
    }

    public void test() throws Exception {
        AtomicReference ref = new AtomicReference();
        this.executeCommand(() -> {
            Component c = (Component)this.getComponentClass().getEPackage().getEFactoryInstance().create(this.getComponentClass());
            ref.set(c);
            this.attachToProject(c);
            CapellaElementExt.creationService((EObject)c);
        });
        Component c = (Component)ref.get();
        AbstractMoveTestCase.assertTrue((c.getRepresentingPartitions().size() > 0 ? 1 : 0) != 0);
        this.executeCommand(() -> this.moveToLibrary(c));
        AbstractMoveTestCase.assertTrue((boolean)this.getPartSetting().containsAll((Collection<?>)c.getRepresentingPartitions()));
    }

    abstract EClass getComponentClass();

    abstract void attachToProject(C var1);

    abstract void moveToLibrary(C var1);

    abstract Collection<?> getPartSetting();
}

