/*******************************************************************************
 * Copyright (c) 2006, 2015 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.test.merge.ju.testcases;

import org.eclipse.osgi.util.NLS;

/**
 * Messages externalization for this package
 */
public class MergeTestingMessages extends NLS {

  private static final String BUNDLE_NAME = "org.polarsys.capella.test.merge.ju.testcases.mergetestingmessages"; //$NON-NLS-1$

  // Merge 1

  public static String scenarioToMergeIdMerge1;
  public static String controlScenarioIdMerge1;
  public static String readableTestNameMerge1;
  public static String testCaseDescMerge1;

  // Dummy UC

  public static String scenarioToMergeIdDummy_UC;
  public static String controlScenarioIdDummy_UC;
  public static String readableTestNameDummy_UC;
  public static String testCaseDescDummy_UC;

  // With EE

  public static String scenarioToMergeIdWithEE;
  public static String controlScenarioIdWithEE;
  public static String readableTestNameWithEE;
  public static String testCaseDescWithEE;

  // With EE (2)

  public static String scenarioToMergeIdWithEE2;
  public static String controlScenarioIdWithEE2;
  public static String readableTestNameWithEE2;
  public static String testCaseDescWithEE2;

  // Dummy LC decomposition

  public static String scenarioToMergeIdWithDummyDec;
  public static String controlScenarioIdWithDummyDec;
  public static String readableTestNameWithDummyDec;
  public static String testCaseDescWithDummyDec;

  // Merge Power

  public static String readableTestNameMergePower;
  public static String testCaseDescMergePower;
  public static String scenarioToMergeIdMergePower;
  public static String controlScenarioIdMergePower;

  // Dummy Reflexive

  public static String readableTestNameReflexiveDummy;
  public static String testCaseDescReflexiveDummy;
  public static String scenarioToMergeIdReflexiveDummy;
  public static String controlScenarioIdReflexiveDummy;

  // Dummy Decomposed Reflexive

  public static String readableTestNameReflexiveDecomposedDummy;
  public static String testCaseDescReflexiveDecomposedDummy;
  public static String scenarioToMergeIdReflexiveDecomposedDummy;
  public static String controlScenarioIdReflexiveDecomposedDummy;

  // Complex Decomposed Reflexive

  public static String readableTestNameReflexiveDecomposedComplex;
  public static String testCaseDescReflexiveDecomposedComplex;
  public static String scenarioToMergeIdReflexiveDecomposedComplex;
  public static String controlScenarioIdReflexiveDecomposedComplex;

  // Re-Use simple case 1

  public static String readableTestNameReUseSimple1;
  public static String testCaseDescReUseSimple1;
  public static String scenarioToMergeIdReUseSimple1;
  public static String controlScenarioIdReUseSimple1;

  // Re-Use simple case 2

  public static String readableTestNameReUseSimple2;
  public static String testCaseDescReUseSimple2;
  public static String scenarioToMergeIdReUseSimple2;
  public static String controlScenarioIdReUseSimple2;

  // Re-Use complex case

  public static String readableTestNameReUseComplex;
  public static String testCaseDescReUseComplex;
  public static String scenarioToMergeIdReUseComplex;
  public static String controlScenarioIdReUseComplex;

  // Decomposed Reflexive with Anchor

  public static String readableTestNameReflexiveDecomposedWithAnchor;
  public static String testCaseDescReflexiveDecomposedWithAnchor;
  public static String scenarioToMergeIdReflexiveDecomposedWithAnchor;
  public static String controlScenarioIdReflexiveDecomposedWithAnchor;

  // Reflexive message with partial part

  public static String readableTestNameReflexiveWithPartialPart;
  public static String testCaseDescReflexiveWithPartialPart;
  public static String scenarioToMergeIdReflexiveWithPartialPart;
  public static String controlScenarioIdReflexiveWithPartialPart;

  // With Communication Mechanismes

  public static String readableTestNameCommunicationMechanismes;
  public static String testCaseDescCommunicationMechanismes;
  public static String scenarioToMergeIdCommunicationMechanismes;
  public static String controlScenarioIdCommunicationMechanismes;

  // With Multi-Part (simple)

  public static String readableTestNameMultiPartSimple;
  public static String testCaseDescMultiPartSimple;
  public static String scenarioToMergeIdMultiPartSimple;
  public static String controlScenarioIdMultiPartSimple;

  // On physical layer

  public static String readableTestNamePhysicalLayer;
  public static String testCaseDescPhysicalLayer;
  public static String scenarioToMergeIdPhysicalLayer;
  public static String controlScenarioIdPhysicalLayer;

  // CF dummy

  public static String readableTestNameCombinedFragmentDummy;
  public static String testCaseDescCombinedFragmentDummy;
  public static String scenarioToMergeIdCombinedFragmentDummy;
  public static String controlScenarioIdCombinedFragmentDummy;

  public static String readableTestNameInteractionStateDummy;
  public static String testCaseDescInteractionStateDummy;
  public static String scenarioToMergeIdInteractionStateDummy;
  public static String controlScenarioIdInteractionStateDummy;

  public static String readableTestNameInteractionUseDummy;
  public static String testCaseDescInteractionUseDummy;
  public static String scenarioToMergeIdInteractionUseDummy;
  public static String controlScenarioIdInteractionUseDummy;

  public static String readableTestNameCreateDeleteMsgDummy;
  public static String testCaseDescCreateDeleteMsgDummy;
  public static String scenarioToMergeIdCreateDeleteMsgDummy;
  public static String controlScenarioIdCreateDeleteMsgDummy;

  // Test on update, on physical layer, without any changes.

  public static String readableTestNameMultiMerge1;
  public static String testCaseDescMultiMerge1;
  public static String scenarioToMergeIdMultiMerge1;
  public static String controlScenarioIdMultiMerge1;

  // Test on update, on logical layer, without any changes.

  public static String readableTestNameMultiMerge2;
  public static String testCaseDescMultiMerge2;
  public static String scenarioToMergeIdMultiMerge2;
  public static String controlScenarioIdMultiMerge2;

  // Tests

  public static String mergeDoesNotSucceed;

  public static String noMergedScenarioCreated;

  // Test on dangling merge links
  public static String scenarioToMergeIdDanglingMergeLink;
  public static String controlScenarioDanglingMergeLink;
  public static String readableTestNameDanglingMergeLink;
  public static String testCaseDescDanglingMergeLink;

  static {
    // initialize resource bundle
    NLS.initializeMessages(BUNDLE_NAME, MergeTestingMessages.class);
  }

  /**
   * Constructor.
   */
  private MergeTestingMessages() {
    // Do nothing.
  }
}
