/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.merge.ju.testcases;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.junit.Assert;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.refinement.merge.merger.DefaultScenarioMerger;
import org.polarsys.capella.core.refinement.merge.merger.IScenarioMerger;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.EObjectHelper;
import org.polarsys.capella.test.framework.helpers.TestHelper;
import org.polarsys.capella.test.merge.ju.testcases.MergeTestingMessages;
import org.polarsys.capella.test.merge.ju.utils.MergeTestUtils;

public abstract class AbstractMergerTest
extends BasicTestCase {
    String _readableTestName;
    protected String _testCaseDesc;
    protected Map<String, EObject> _semanticObjectMap;
    protected String _scenarioToMergeId;
    protected String _controlScenarioId;
    protected Scenario _result = null;

    public AbstractMergerTest(String scenarioToMergeId, String controlScenarioId, String readableTestName, String testCaseDesc) {
        this._scenarioToMergeId = scenarioToMergeId;
        this._controlScenarioId = controlScenarioId;
        this._readableTestName = readableTestName;
        this._testCaseDesc = testCaseDesc;
    }

    public void test() throws Exception {
        Scenario scenario = (Scenario)this._semanticObjectMap.get(this._scenarioToMergeId);
        DefaultScenarioMerger ism = new DefaultScenarioMerger();
        this._result = MergeTestUtils.performMerge(scenario, (IScenarioMerger)ism);
        Assert.assertNotNull((String)MergeTestingMessages.noMergedScenarioCreated, (Object)this._result);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setObjects();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.cleanUp();
    }

    protected void setObjects() {
        Resource semanticResource = TestHelper.getSemanticResource((Session)this.getSession((String)this.getRequiredTestModels().get(0)));
        this._semanticObjectMap = new HashMap<String, EObject>();
        ArrayList<String> list = new ArrayList<String>();
        list.add(this._scenarioToMergeId);
        list.add(this._controlScenarioId);
        Map map = EObjectHelper.getMatchingEObject((EObject)((EObject)semanticResource.getContents().get(0)), (EClass)ModellingcorePackage.Literals.MODEL_ELEMENT, (EStructuralFeature)ModellingcorePackage.Literals.MODEL_ELEMENT__ID, list);
        this._semanticObjectMap.putAll(map);
    }

    protected void cleanUp() {
        this._semanticObjectMap.clear();
        this._result = null;
    }
}

