/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.migration.ju.testcases.basic;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.ui.properties.annotations.RepresentationAnnotationHelper;
import org.polarsys.capella.test.framework.helpers.GuiActions;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.test.migration.ju.helpers.MigrationHelper;
import org.polarsys.capella.test.migration.ju.model.MigrationDiagram;

public class FixDAnnotationsContributionTest
extends MigrationDiagram {
    private static List<String> dAnnotationMigrationMapping = Arrays.asList("http://www.thalesgroup.com/mde/melody/NotVisibleInDoc", "http://www.thalesgroup.com/mde/melody/NotVisibleInLM", "http://www.thalesgroup.com/mde/melody/ProgressStatus", "http://www.thalesgroup.com/mde/melody/StatusReview");
    private static String BASIC_ANNOTATION = "basicAnnotation";

    public void test() throws Exception {
        IProject project = IResourceHelpers.getEclipseProjectInWorkspace((String)this.getRequiredTestModels().get(0));
        if (project.exists()) {
            this.addAnnotations();
            MigrationHelper.migrateProject(project);
            this.checkAnnotations();
        }
    }

    private void addAnnotations() {
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)session.getTransactionalEditingDomain()).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                Session session = FixDAnnotationsContributionTest.this.getSessionForTestModel(FixDAnnotationsContributionTest.this.getRequiredTestModels().get(0));
                Collection diagrams = DialectManager.INSTANCE.getAllRepresentations(session);
                FixDAnnotationsContributionTest.assertTrue((String)"Test model should contain at least one diagram", (!diagrams.isEmpty() ? 1 : 0) != 0);
                for (DRepresentation representation : diagrams) {
                    RepresentationAnnotationHelper.setAnnotation((DRepresentation)representation, (String)BASIC_ANNOTATION, (Boolean)Boolean.FALSE);
                    FixDAnnotationsContributionTest.assertNotNull((Object)RepresentationHelper.getAnnotation((String)BASIC_ANNOTATION, (DRepresentation)representation));
                    for (String annotationKey : dAnnotationMigrationMapping) {
                        RepresentationAnnotationHelper.setAnnotation((DRepresentation)representation, (String)annotationKey, (Boolean)Boolean.FALSE);
                    }
                    RepresentationAnnotationHelper.setAnnotation((DRepresentation)representation, (String)"http://www.polarsys.org/capella/core/NotVisibleInDoc", (Boolean)Boolean.FALSE);
                    RepresentationAnnotationHelper.setAnnotation((DRepresentation)representation, (String)"http://www.polarsys.org/capella/core/NotVisibleInLM", (Boolean)Boolean.FALSE);
                }
            }
        });
        GuiActions.saveSession((Session)session);
        GuiActions.closeSession((Session)session);
    }

    private void checkAnnotations() {
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        for (DRepresentation representation : DialectManager.INSTANCE.getAllRepresentations(session)) {
            FixDAnnotationsContributionTest.assertNotNull((Object)RepresentationHelper.getAnnotation((String)BASIC_ANNOTATION, (DRepresentation)representation));
            for (String annotationKey : dAnnotationMigrationMapping) {
                FixDAnnotationsContributionTest.assertNull((Object)RepresentationHelper.getAnnotation((String)annotationKey, (DRepresentation)representation));
            }
            FixDAnnotationsContributionTest.assertNotNull((Object)RepresentationHelper.getAnnotation((String)"http://www.polarsys.org/capella/core/NotVisibleInDoc", (DRepresentation)representation));
            FixDAnnotationsContributionTest.assertNotNull((Object)RepresentationHelper.getAnnotation((String)"http://www.polarsys.org/capella/core/NotVisibleInLM", (DRepresentation)representation));
        }
        System.out.println();
    }
}

