/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.testcase.dialoglabel;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.sequence.description.SequenceDiagramDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.projection.commands.ESToISCommand;
import org.polarsys.capella.core.sirius.ui.actions.NewRepresentationAction;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class NewDiagramDialogLabel
extends BasicTestCase {
    public static String MODEL_NAME = "DiagramLabelModel";
    public static String SA__CAPABILITIES__CAPABILITY_1__ES_CAPABILITY_1 = "6d6a0f72-7a57-4642-8644-34479dc37508";
    public static String TESTED_LABEL1 = "[IS] [ES] Capability 1";
    public static String SA__CAPABILITIES__CAPABILITY_1__IS_CAPABILITY_1 = "efca3884-db70-459c-95a8-bc7eb90af5b6";
    public static String TESTED_LABEL2 = "[IS] Capability 1";
    public static String LA__CAPABILITIES__CAPABILITYREALIZATION_1__ES_CAPABILITYREALIZATION_1 = "d7006415-2c80-46b5-8c37-af29de2ddf2f";
    public static String LA__CAPABILITIES__CAPABILITYREALIZATION_1 = "f11a2250-317f-4f42-8cc8-9f2094a09e39";
    public static String TESTED_LABEL3 = "[IS] [ES] CapabilityRealization 1 (IS)";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(MODEL_NAME);
    }

    public void test() {
        CapellaModel model = this.getTestModel(MODEL_NAME);
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        EObject scenario1 = IdManager.getInstance().getEObject(SA__CAPABILITIES__CAPABILITY_1__ES_CAPABILITY_1, (IScope)scope);
        EObject scenario2 = IdManager.getInstance().getEObject(SA__CAPABILITIES__CAPABILITY_1__IS_CAPABILITY_1, (IScope)scope);
        EObject scenario3 = IdManager.getInstance().getEObject(LA__CAPABILITIES__CAPABILITYREALIZATION_1__ES_CAPABILITYREALIZATION_1, (IScope)scope);
        CapabilityRealization capability = (CapabilityRealization)IdManager.getInstance().getEObject(LA__CAPABILITIES__CAPABILITYREALIZATION_1, (IScope)scope);
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        TransactionHelper.getExecutionManager((EObject)scenario3).execute((ICommand)new ESToISCommand(Arrays.asList(scenario3)));
        EObject transformedScenario = (EObject)capability.getOwnedScenarios().get(1);
        Collection selectedViewpoints = session.getSelectedViewpoints(false);
        for (Viewpoint vp : selectedViewpoints) {
            for (RepresentationDescription representationDescription : vp.getOwnedRepresentations()) {
                if (!(representationDescription instanceof SequenceDiagramDescription)) continue;
                this.testScenarioActionLabel(scenario1, session, (SequenceDiagramDescription)representationDescription, TESTED_LABEL1);
                this.testScenarioActionLabel(scenario2, session, (SequenceDiagramDescription)representationDescription, TESTED_LABEL2);
                this.testScenarioActionLabel(transformedScenario, session, (SequenceDiagramDescription)representationDescription, TESTED_LABEL3);
            }
        }
    }

    private void testScenarioActionLabel(EObject object, Session session, SequenceDiagramDescription sdd, String labelToTest) {
        if (DialectManager.INSTANCE.canCreate(object, (RepresentationDescription)sdd)) {
            String computedActionLabel = new NewRepresentationAction((RepresentationDescription)sdd, object, session){

                public String computeDefaultName(EObject eObject, RepresentationDescription repDescription) {
                    return super.computeDefaultName(eObject, repDescription);
                }
            }.computeDefaultName(object, (RepresentationDescription)sdd);
            NewDiagramDialogLabel.assertTrue((String)("Dialog label for new diagram should be: " + labelToTest), (boolean)computedActionLabel.equals(labelToTest));
        }
    }
}

