/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.projection.ju;

import com.google.common.base.Predicate;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellacore.Trace;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.model.helpers.PortExt;
import org.polarsys.capella.core.projection.commands.GenerateInterfacesCommand;
import org.polarsys.capella.core.projection.common.AbstractTransform;
import org.polarsys.capella.core.projection.interfaces.InterfaceGeneration;
import org.polarsys.capella.core.projection.interfaces.InterfaceGenerationPreferences;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class GenerateInterfacesTest
extends BasicTestCase {
    protected Resource modelResource;
    private final Predicate<Component> testComponentPredicate;
    private final String testComponentName;
    private final Multimap<ComponentPort, Interface> expectedRequired = LinkedHashMultimap.create();
    private final Multimap<ComponentPort, Interface> expectedProvided = LinkedHashMultimap.create();
    private final Multimap<Interface, Trace> expectedTraces = LinkedHashMultimap.create();

    public GenerateInterfacesTest(String testComponentName) {
        this.testComponentPredicate = this.hasName(testComponentName);
        this.testComponentName = testComponentName;
    }

    public String getName() {
        return this.testComponentName;
    }

    public void test() throws Exception {
        Component component = this.find(this.getModelResource(), Component.class, this.testComponentPredicate);
        this.verifyNoChangeOnExecute(component);
        for (ComponentPort port : component.getContainedComponentPorts()) {
            this.clearPort(port);
            for (ComponentPort connected : PortExt.getConnectedComponentPorts((ComponentPort)port)) {
                this.clearPort(connected);
            }
            for (FunctionPort fp : port.getAllocatedFunctionPorts()) {
                if (fp instanceof FunctionOutputPort) {
                    for (FunctionalExchange fe : ((FunctionOutputPort)fp).getOutgoingFunctionalExchanges()) {
                        for (ComponentPort otherPort : fe.getTargetFunctionInputPort().getAllocatorComponentPorts()) {
                            this.clearPort(otherPort);
                        }
                    }
                }
                if (!(fp instanceof FunctionInputPort)) continue;
                for (FunctionalExchange fe : ((FunctionInputPort)fp).getIncomingFunctionalExchanges()) {
                    for (ComponentPort otherPort : fe.getSourceFunctionOutputPort().getAllocatorComponentPorts()) {
                        this.clearPort(otherPort);
                    }
                }
            }
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)component);
        GenerateInterfacesCommand command = new GenerateInterfacesCommand(Collections.singleton(component));
        ExecutionManager manager = ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)domain);
        manager.execute((ICommand)command);
        for (ComponentPort port : component.getContainedComponentPorts()) {
            this.verify(port, this.expectedProvided, this.expectedRequired, this.expectedTraces);
            for (ComponentPort connected : PortExt.getConnectedComponentPorts((ComponentPort)port)) {
                this.verify(connected, this.expectedProvided, this.expectedRequired, this.expectedTraces);
            }
        }
        GenerateInterfacesTest.assertTrue((boolean)HoldingResourceHelper.getHoldingResource((TransactionalEditingDomain)domain).getContents().isEmpty());
    }

    private void verifyNoChangeOnExecute(Component component) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)component);
        ResourceSetChangeListener listener = new ResourceSetChangeListener();
        domain.addResourceSetListener((ResourceSetListener)listener);
        try {
            GenerateInterfacesCommand command = this.createCommand(Collections.singleton(component));
            ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)domain).execute((ICommand)command);
        }
        finally {
            domain.removeResourceSetListener((ResourceSetListener)listener);
        }
        GenerateInterfacesTest.assertFalse((boolean)listener.hasChanged());
    }

    private void clearTraces(Interface namespace, Multimap<Interface, Trace> expectedTraces) {
        Iterator it = namespace.getOwnedTraces().iterator();
        while (it.hasNext()) {
            expectedTraces.put((Object)namespace, (Object)((Trace)it.next()));
            it.remove();
        }
    }

    private void clearPort(final ComponentPort port) {
        this.expectedRequired.putAll((Object)port, (Iterable)port.getRequiredInterfaces());
        this.expectedProvided.putAll((Object)port, (Iterable)port.getProvidedInterfaces());
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)port);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                Iterator it = port.getRequiredInterfaces().iterator();
                while (it.hasNext()) {
                    GenerateInterfacesTest.this.clearTraces((Interface)it.next(), (Multimap<Interface, Trace>)GenerateInterfacesTest.this.expectedTraces);
                    it.remove();
                }
                it = port.getProvidedInterfaces().iterator();
                while (it.hasNext()) {
                    GenerateInterfacesTest.this.clearTraces((Interface)it.next(), (Multimap<Interface, Trace>)GenerateInterfacesTest.this.expectedTraces);
                    it.remove();
                }
            }
        });
    }

    private void verify(ComponentPort port, Multimap<ComponentPort, Interface> expectedProvided, Multimap<ComponentPort, Interface> expectedRequired, Multimap<Interface, Trace> expectedTraces) {
        Interface[] expectedProvidedArray = expectedProvided.get((Object)port).toArray(new Interface[0]);
        GenerateInterfacesTest.assertSame((Object)expectedProvidedArray.length, (Object)port.getProvidedInterfaces().size());
        int i = 0;
        while (i < expectedProvidedArray.length) {
            Interface expected = expectedProvidedArray[i];
            Interface actual = (Interface)port.getProvidedInterfaces().get(i);
            GenerateInterfacesTest.assertTrue((boolean)this.equals(expected, actual));
            this.verifyTraces(expected, actual, expectedTraces.get((Object)expected));
            ++i;
        }
        Interface[] expectedRequiredArray = expectedRequired.get((Object)port).toArray(new Interface[0]);
        GenerateInterfacesTest.assertSame((Object)expectedRequiredArray.length, (Object)port.getRequiredInterfaces().size());
        int i2 = 0;
        while (i2 < expectedRequiredArray.length) {
            Interface expected = expectedRequiredArray[i2];
            Interface actual = (Interface)port.getRequiredInterfaces().get(i2);
            GenerateInterfacesTest.assertTrue((boolean)this.equals(expected, actual));
            this.verifyTraces(expected, actual, expectedTraces.get((Object)expected));
            ++i2;
        }
    }

    private void verifyTraces(Interface expected, Interface actual, Collection<Trace> expectedTraces) {
        GenerateInterfacesTest.assertSame((Object)expectedTraces.size(), (Object)actual.getOwnedTraces().size());
        block0: for (Trace et : expectedTraces) {
            for (Trace at : actual.getOwnedTraces()) {
                if (at.getTargetElement() == et.getTargetElement()) continue block0;
            }
            GenerateInterfacesTest.fail((String)("Could not find expected trace to " + et.getTargetElement() + " on interface" + actual.getName()));
        }
    }

    private boolean equals(Interface expected, Interface actual) {
        boolean result = new InterfaceEquality().equals((EObject)expected, (EObject)actual);
        return result;
    }

    public List<String> getRequiredTestModels() {
        return Collections.singletonList("testInterfacesFromAllocatedFunctions");
    }

    <T> T find(Resource res, Class<T> clazz, Predicate<T> predicate) {
        TreeIterator it = res.getAllContents();
        while (it.hasNext()) {
            T candidate;
            EObject next = (EObject)it.next();
            if (!clazz.isInstance(next) || !predicate.apply(candidate = clazz.cast(next))) continue;
            return candidate;
        }
        return null;
    }

    private GenerateInterfacesCommand createCommand(Collection<EObject> rootElements) {
        return new GenerateInterfacesCommand(rootElements){

            protected AbstractTransform getTransformation(EObject element_p) {
                return new InterfaceGeneration(new InterfaceGenerationPreferences(){

                    public boolean isGenerateComponentExchanges() {
                        return false;
                    }
                }, false);
            }
        };
    }

    <T> Collection<T> findAll(Resource res, Class<T> clazz, Predicate<T> predicate) {
        ArrayList<T> result = new ArrayList<T>();
        TreeIterator it = res.getAllContents();
        while (it.hasNext()) {
            T candidate;
            EObject next = (EObject)it.next();
            if (!clazz.isInstance(next) || !predicate.apply(candidate = clazz.cast(next))) continue;
            result.add(candidate);
        }
        return result;
    }

    <T extends NamedElement> Predicate<T> hasName(final String name) {
        return new Predicate<T>(){

            public boolean apply(T input) {
                return StringUtils.equals((String)name, (String)input.getName());
            }
        };
    }

    protected Resource getModelResource() {
        if (this.modelResource == null) {
            Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
            this.modelResource = TestHelper.getSemanticResource((Session)session);
        }
        return this.modelResource;
    }

    static class InterfaceEquality
    extends EcoreUtil.EqualityHelper {
        private static final long serialVersionUID = -5651855427813503525L;

        InterfaceEquality() {
        }

        protected boolean haveEqualFeature(EObject expected, EObject actual, EStructuralFeature feature) {
            if (feature == CapellacorePackage.Literals.NAMESPACE__OWNED_TRACES) {
                return true;
            }
            if (feature == ModellingcorePackage.Literals.MODEL_ELEMENT__ID) {
                return true;
            }
            return super.haveEqualFeature(expected, actual, feature);
        }
    }

    public static class ResourceSetChangeListener
    extends ResourceSetListenerImpl {
        boolean changed = false;

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            this.changed = true;
        }

        public boolean hasChanged() {
            return this.changed;
        }
    }
}

