/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.re.updateconnections.ju;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.IMergeSelector;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.re.updateconnections.ui.ConnectionMatcher;
import org.polarsys.capella.core.re.updateconnections.ui.DiffmergeHandler;
import org.polarsys.capella.core.re.updateconnections.ui.SingleUsePortsMatcher;
import org.polarsys.capella.test.framework.api.BasicCommandTestCase;
import org.polarsys.capella.test.framework.api.BasicTestArtefact;
import org.polarsys.capella.test.framework.api.BasicTestSuite;

public abstract class UpdateConnectionsTest
extends BasicCommandTestCase {
    public static final String RPL1_Name = "RPL1";
    public static final String RPL2_Name = "RPL2";
    public static final String PRESENCE_PREFIX = "presence_";
    protected CatalogElement rpl1;
    protected CatalogElement rpl2;
    protected Collection<EObject> expectedPresences = new ArrayList<EObject>();

    public void setUp() throws Exception {
        super.setUp();
        this.rpl1 = this.findCatalogElement(this.getModelResource(), RPL1_Name);
        this.rpl2 = this.findCatalogElement(this.getModelResource(), RPL2_Name);
        this.expectedPresences = this.findAllExpectedPresences(this.rpl1.getOrigin().eResource());
    }

    private Collection<EObject> findAllExpectedPresences(Resource res) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        TreeIterator it = EcoreUtil.getAllContents((Resource)res, (boolean)true);
        while (it.hasNext()) {
            NamedElement ne;
            EObject next = (EObject)it.next();
            if (!(next instanceof NamedElement) || (ne = (NamedElement)next).getName() == null || !ne.getName().startsWith(PRESENCE_PREFIX)) continue;
            result.add(next);
            if (next instanceof ComponentExchange) {
                result.addAll((Collection<EObject>)((ComponentExchange)next).getOwnedComponentExchangeEnds());
            }
            if (!(next instanceof PhysicalLink)) continue;
            result.addAll((Collection<EObject>)((PhysicalLink)next).getOwnedPhysicalLinkEnds());
        }
        return result;
    }

    private CatalogElement findCatalogElement(Resource res, String name) {
        TreeIterator it = EcoreUtil.getAllContents((Resource)res, (boolean)true);
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof CatalogElement) || !((CatalogElement)next).getName().equals(name)) continue;
            return (CatalogElement)next;
        }
        return null;
    }

    public void performTest() throws Exception {
        UpdateConnectionsTest.assertNotNull((Object)this.rpl1);
        UpdateConnectionsTest.assertNotNull((Object)this.rpl2);
        DiffmergeHandler handler = new DiffmergeHandler(this.rpl1, this.rpl2, (ConnectionMatcher)new SingleUsePortsMatcher());
        EComparison comp = handler.computeDifferences((IProgressMonitor)new NullProgressMonitor());
        UpdateConnectionsTest.assertTrue((boolean)comp.getDuplicateMatchIDs(Role.TARGET).isEmpty());
        UpdateConnectionsTest.assertTrue((boolean)comp.getDuplicateMatchIDs(Role.REFERENCE).isEmpty());
        ArrayList<EObject> remainingExpectedPresences = new ArrayList<EObject>(this.expectedPresences);
        for (IDifference diff : comp.getRemainingDifferences()) {
            if (!(diff instanceof IElementPresence)) continue;
            IElementPresence presence = (IElementPresence)diff;
            UpdateConnectionsTest.assertSame((Object)Role.TARGET, (Object)presence.getPresenceRole());
            UpdateConnectionsTest.assertTrue((boolean)remainingExpectedPresences.remove(presence.getElement()));
        }
        UpdateConnectionsTest.assertTrue((boolean)remainingExpectedPresences.isEmpty());
        IMergeSelector sel = new IMergeSelector(){

            public Role getMergeDirection(IDifference difference) {
                if (difference instanceof IElementPresence) {
                    return Role.REFERENCE;
                }
                return null;
            }
        };
        Collection allMergedDifferences = comp.merge(sel, true, (IProgressMonitor)new NullProgressMonitor());
        UpdateConnectionsTest.assertSame((Object)this.expectedPresences.size(), (Object)allMergedDifferences.size());
        for (IDifference diff : allMergedDifferences) {
            EObject copy = ((IElementPresence)diff).getElementMatch().get(Role.REFERENCE);
            UpdateConnectionsTest.assertTrue((copy.eContainer() != null ? 1 : 0) != 0);
        }
        handler = new DiffmergeHandler(this.rpl1, this.rpl2, (ConnectionMatcher)new SingleUsePortsMatcher());
        comp = handler.computeDifferences((IProgressMonitor)new NullProgressMonitor());
        for (IDifference diff : comp.getRemainingDifferences()) {
            if (!(diff instanceof IElementPresence)) continue;
            UpdateConnectionsTest.fail((String)"Found unexpected element presence differences after merge");
        }
    }

    protected Resource getModelResource() {
        if (this.modelResource == null) {
            Session session = this.getSessionForTestModel((String)this.getRequiredTestModels().get(0));
            for (Resource resource : session.getSemanticResources()) {
                if (((EObject)resource.getContents().get(0)).eClass() != CapellamodellerPackage.Literals.PROJECT) continue;
                this.modelResource = resource;
            }
        }
        return this.modelResource;
    }

    public static class Library
    extends UpdateConnectionsTest {
        public List<String> getRequiredTestModels() {
            return Arrays.asList("updatelinksTest2", "updatelinksTest2Lib");
        }
    }

    public static class Multipart
    extends UpdateConnectionsTest {
        public List<String> getRequiredTestModels() {
            return Collections.singletonList("updatelinksTest3Multipart");
        }
    }

    public static class Simple
    extends UpdateConnectionsTest {
        public List<String> getRequiredTestModels() {
            return Collections.singletonList("updatelinksTest1");
        }
    }

    public static class UpdateConnectionsTestSuite
    extends BasicTestSuite {
        protected List<BasicTestArtefact> getTests() {
            ArrayList<BasicTestArtefact> list = new ArrayList<BasicTestArtefact>();
            list.add((BasicTestArtefact)new Simple());
            list.add((BasicTestArtefact)new Library());
            list.add((BasicTestArtefact)new Multipart());
            return list;
        }
    }
}

