/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.recrpl.ju;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.common.queries.queryContext.QueryContext;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementKind;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.RecCatalog;
import org.polarsys.capella.common.re.helpers.ReplicableElementExt;
import org.polarsys.capella.common.re.queries.CatalogElement_AllUsedElements;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.re.commands.CreateRecCommand;
import org.polarsys.capella.core.re.commands.CreateReplicaCommand;
import org.polarsys.capella.core.re.commands.DeleteReplicaAndRelatedElementsCommand;
import org.polarsys.capella.core.re.commands.DeleteReplicaPreserveRelatedElementsCommand;
import org.polarsys.capella.core.re.commands.UpdateCurCommand;
import org.polarsys.capella.core.re.commands.UpdateDefCommand;
import org.polarsys.capella.core.re.commands.UpdateReplicaCommand;
import org.polarsys.capella.core.transition.common.handlers.merge.DefaultMergeHandler;
import org.polarsys.capella.core.transition.common.handlers.merge.ICategoryItem;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.recrpl.ju.RecRplCommandManager;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public abstract class RecRplTestCase
extends BasicTestCase {
    protected Resource modelResource;

    protected void setSuffixed(CatalogElement rec, String target) {
        EObject REC_LF1 = this.getObject(target);
        for (CatalogElementLink link : rec.getOwnedLinks()) {
            if (link.getTarget() != REC_LF1) continue;
            link.setSuffixed(true);
        }
    }

    public void test() throws Exception {
        final Exception[] t = new Exception[1];
        TransactionHelper.getExecutionManager((EObject)this.getProject()).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                try {
                    RecRplTestCase.this.performTest();
                }
                catch (Exception e) {
                    t[0] = e;
                }
            }
        });
        if (t[0] != null) {
            throw t[0];
        }
    }

    protected void mustBeOwnedBy(EObject object, EObject container) {
        RecRplTestCase.assertTrue((object != null ? 1 : 0) != 0);
        RecRplTestCase.assertTrue((boolean)object.eContainer().equals(container));
    }

    public void performTest() throws Exception {
    }

    protected CatalogElement createREC(Collection<? extends EObject> elements) {
        CreateRecCommand command = new CreateRecCommand(elements, (IProgressMonitor)new NullProgressMonitor());
        this.executeCommand((ICommand)command);
        RecRplTestCase.assertFalse((boolean)command.isRolledBack());
        CatalogElement newREC = null;
        for (EObject eObject : elements) {
            Collection relatedRecs = ReplicableElementExt.getReferencingReplicableElements((EObject)eObject);
            CatalogElement lastRec = relatedRecs.toArray(new CatalogElement[0])[relatedRecs.size() - 1];
            RecRplTestCase.assertTrue((lastRec != null ? 1 : 0) != 0);
            RecRplTestCase.assertTrue((newREC == null || lastRec == newREC ? 1 : 0) != 0);
            newREC = lastRec;
        }
        RecRplTestCase.assertTrue((newREC.eContainer() != null ? 1 : 0) != 0);
        return newREC;
    }

    protected CatalogElement createReplica(Collection<EObject> elements, CatalogElement REC) {
        return this.createReplica(elements, REC, null);
    }

    protected CatalogElement createReplica(Collection<? extends EObject> selection, CatalogElement REC, String suffix) {
        Collection RPLS = ReplicableElementExt.getReplicas((CatalogElement)REC);
        CreateReplicaCommand command = new CreateReplicaCommand(selection, (IProgressMonitor)new NullProgressMonitor());
        RecRplCommandManager.push("isource", REC);
        if (suffix != null) {
            RecRplCommandManager.push("suffix", suffix);
        }
        this.executeCommand((ICommand)command);
        RecRplTestCase.assertFalse((boolean)command.isRolledBack());
        Collection RPLS2 = ReplicableElementExt.getReplicas((CatalogElement)REC);
        RPLS2.removeAll(RPLS);
        RecRplTestCase.assertTrue((RPLS2.size() == 1 ? 1 : 0) != 0);
        CatalogElement RPL = (CatalogElement)RPLS2.iterator().next();
        RecRplTestCase.assertTrue((RPL.getKind() == CatalogElementKind.RPL ? 1 : 0) != 0);
        RecRplTestCase.assertTrue((boolean)RPL.getOrigin().equals(REC));
        for (Object element : QueryInterpretor.executeQuery((String)CatalogElement_AllUsedElements.class.getSimpleName(), (Object)REC, (IQueryContext)new QueryContext())) {
            EObject ref = ReplicableElementExt.getReferencingElement((CatalogElement)RPL, (EObject)((EObject)element));
            RecRplTestCase.assertTrue((ref != null && ref != element ? 1 : 0) != 0);
        }
        return RPL;
    }

    protected void updateCur(Collection<EObject> selection, CatalogElement rec) {
        UpdateCurCommand command = new UpdateCurCommand(selection, (IProgressMonitor)new NullProgressMonitor());
        RecRplCommandManager.push("itarget", rec);
        this.executeCommand((ICommand)command);
        RecRplTestCase.assertFalse((boolean)command.isRolledBack());
    }

    protected void updateReplica(Collection<EObject> elements, CatalogElement replica) {
        UpdateReplicaCommand command = new UpdateReplicaCommand(elements, (IProgressMonitor)new NullProgressMonitor());
        RecRplCommandManager.push("itarget", replica);
        this.executeCommand((ICommand)command);
        RecRplTestCase.assertFalse((boolean)command.isRolledBack());
    }

    protected void updateReplica(Collection<EObject> elements, CatalogElement replica, String suffix) {
        UpdateReplicaCommand command = new UpdateReplicaCommand(elements, (IProgressMonitor)new NullProgressMonitor());
        RecRplCommandManager.push("itarget", replica);
        RecRplCommandManager.push("suffix", suffix);
        this.executeCommand((ICommand)command);
        RecRplTestCase.assertFalse((boolean)command.isRolledBack());
    }

    protected boolean updateReplica(Collection<EObject> elements, CatalogElement replica, final Collection<String> disabledCategoryFilters) {
        UpdateReplicaCommand command = new UpdateReplicaCommand(elements, (IProgressMonitor)new NullProgressMonitor());
        command.addSharedParameter(new GenericParameter("MERGE_DIFFERENCES_HANDLER", (Object)new DefaultMergeHandler(true){

            public void addCategory(ICategoryItem filter, IContext context) {
                super.addCategory(filter, context);
                if (disabledCategoryFilters.contains(filter.getId())) {
                    filter.setActive(false);
                }
            }
        }, "Merge"));
        RecRplCommandManager.push("itarget", replica);
        this.executeCommand((ICommand)command);
        return !command.isRolledBack();
    }

    protected void updateDef(Collection<EObject> elements) {
        UpdateDefCommand command = new UpdateDefCommand(elements, (IProgressMonitor)new NullProgressMonitor());
        this.executeCommand((ICommand)command);
    }

    protected void deleteReplicaAndRelatedElements(Collection<EObject> elements) {
        DeleteReplicaAndRelatedElementsCommand command = new DeleteReplicaAndRelatedElementsCommand(elements, (IProgressMonitor)new NullProgressMonitor());
        this.executeCommand((ICommand)command);
    }

    protected void deleteReplicaPreserveRelatedElements(Collection<EObject> elements) {
        DeleteReplicaPreserveRelatedElementsCommand command = new DeleteReplicaPreserveRelatedElementsCommand(elements, (IProgressMonitor)new NullProgressMonitor());
        this.executeCommand((ICommand)command);
    }

    protected void mustReference(CatalogElement rec, EObject object) {
        RecRplTestCase.assertTrue((boolean)ReplicableElementExt.getReferencingReplicableElements((EObject)object).contains(rec));
    }

    protected void mustNotReference(CatalogElement rec, EObject object) {
        RecRplTestCase.assertTrue((!ReplicableElementExt.getReferencingReplicableElements((EObject)object).contains(rec) ? 1 : 0) != 0);
    }

    protected RecCatalog getRecCatalog() {
        Project project = this.getProject();
        SystemEngineering sys = SystemEngineeringExt.getSystemEngineering((Project)project);
        for (EObject element : sys.getOwnedExtensions()) {
            if (!(element instanceof RecCatalog)) continue;
            return (RecCatalog)element;
        }
        return null;
    }

    protected CatalogElement getREC(String name) {
        for (CatalogElement element : this.getRecCatalog().getOwnedElements()) {
            if (element.getKind() != CatalogElementKind.REC || !element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    protected Resource getModelResource() {
        if (this.modelResource == null) {
            Session session = this.getSessionForTestModel((String)this.getRequiredTestModels().get(0));
            for (Resource resource : session.getSemanticResources()) {
                if (!(resource.getContents().get(0) instanceof Project)) continue;
                this.modelResource = resource;
            }
        }
        return this.modelResource;
    }

    protected Project getProject() {
        return (Project)this.getModelResource().getContents().iterator().next();
    }

    protected void executeCommand(ICommand command) {
        try {
            TransactionHelper.getExecutionManager((EObject)this.getProject()).execute(command);
        }
        finally {
            RecRplCommandManager.clear();
        }
    }

    protected boolean executeCommand(final Runnable r) {
        AbstractReadWriteCommand arwc = new AbstractReadWriteCommand(){

            public void run() {
                r.run();
            }
        };
        this.executeCommand((ICommand)arwc);
        return !arwc.isRolledBack();
    }

    protected void expectRollback(Runnable r) {
        RecRplTestCase.assertFalse((boolean)this.executeCommand(r));
    }

    protected void expectNoRollback(Runnable r) {
        RecRplTestCase.assertTrue((boolean)this.executeCommand(r));
    }

    protected void expectNoRollback(boolean b) {
        RecRplTestCase.assertTrue((boolean)b);
    }

    protected EObject getObject(String id) {
        return this.getModelResource().getEObject(id);
    }

    protected Collection<EObject> getObjects(String ... ids) {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            EObject object = this.getObject(id);
            RecRplTestCase.assertNotNull((Object)object);
            objects.add(object);
            ++n2;
        }
        return objects;
    }
}

