/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.recrpl.ju.testcases.compliance;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.test.recrpl.ju.model.Compliance;

public class BlackboxComplianceTest1
extends Compliance {
    private PhysicalArchitecture pa;
    private PhysicalComponent rootPC;
    private CatalogElement rec;
    private PhysicalComponent pcRec;
    private CatalogElement rpl;
    private PhysicalComponent pcRpl;
    private PhysicalFunction rootPf;
    private PhysicalFunction pfRec;
    private PhysicalFunction pfRpl;

    @Override
    public void test() throws Exception {
        SystemEngineering se = SystemEngineeringExt.getSystemEngineering((Project)this.getProject());
        this.pa = SystemEngineeringExt.getPhysicalArchitecture((SystemEngineering)se);
        this.rootPC = SystemEngineeringExt.getRootPhysicalComponent((PhysicalArchitecture)this.pa);
        this.rootPf = (PhysicalFunction)BlockArchitectureExt.getRootFunction((BlockArchitecture)this.pa);
        this.expectNoRollback(() -> {
            this.pcRec = PaFactory.eINSTANCE.createPhysicalComponent("PC1");
            this.pcRec.setDescription("pc description");
            this.rootPC.getOwnedPhysicalComponents().add((Object)this.pcRec);
        });
        this.rec = this.createREC(Collections.singleton(this.pcRec));
        this.rpl = this.createReplica(Collections.singleton(this.rootPC), this.rec, "SUFFIX");
        this.pcRpl = (PhysicalComponent)((CatalogElementLink)this.rpl.getOwnedLinks().iterator().next()).getTarget();
        BlackboxComplianceTest1.assertSame((Object)this.pa.getOwnedPhysicalComponent(), (Object)this.pcRpl.eContainer());
        String origPcRplName = this.pcRpl.getName();
        String origPcRplDescription = this.pcRpl.getDescription();
        this.expectNoRollback(() -> this.rpl.setReadOnly(true));
        this.expectRollback(() -> this.pcRpl.setName("x"));
        this.expectRollback(() -> this.pcRpl.setDescription("d"));
        this.expectNoRollback(() -> this.rpl.setReadOnly(false));
        this.expectNoRollback(() -> this.pcRpl.setName("x"));
        this.expectNoRollback(() -> this.pcRpl.setDescription("d"));
        this.expectNoRollback(() -> this.rpl.setReadOnly(true));
        this.expectNoRollback(() -> this.pcRpl.setName(origPcRplName));
        this.expectNoRollback(() -> this.pcRpl.setDescription(origPcRplDescription));
        this.expectNoRollback(() -> {
            this.pfRec = PaFactory.eINSTANCE.createPhysicalFunction("pf1");
            this.rootPf.getOwnedFunctions().add((Object)this.pfRec);
            FaServices.getFaServices().allocateToComponent((AbstractFunction)this.pfRec, (Component)this.pcRec);
        });
        this.updateCur(Collections.singleton(this.pfRec), this.rec);
        this.updateReplica(Collections.singleton(this.rpl), this.rpl);
        for (CatalogElementLink link : this.rpl.getOwnedLinks()) {
            if (!(link.getTarget() instanceof PhysicalFunction)) continue;
            this.pfRpl = (PhysicalFunction)link.getTarget();
        }
        BlackboxComplianceTest1.assertSame((Object)this.rootPf, (Object)this.pfRpl.eContainer());
        this.expectRollback(() -> {
            boolean bl = this.pcRpl.getOwnedPhysicalComponents().add((Object)PaFactory.eINSTANCE.createPhysicalComponent("sub"));
        });
        this.expectRollback(() -> this.pcRpl.getOwnedPhysicalComponents().addAll(Arrays.asList(PaFactory.eINSTANCE.createPhysicalComponent("sub1"), PaFactory.eINSTANCE.createPhysicalComponent("sub2"))));
        ComponentFunctionalAllocation alloc = (ComponentFunctionalAllocation)this.pcRpl.getOwnedFunctionalAllocation().get(0);
        this.expectRollback(() -> EcoreUtil.delete((EObject)alloc));
        new CapellaDeleteCommand(TransactionHelper.getExecutionManager((EObject)this.pfRpl), Collections.singleton(alloc), true, false, false).execute();
        BlackboxComplianceTest1.assertSame((Object)this.pcRpl, (Object)alloc.eContainer());
        this.expectRollback(() -> EcoreUtil.delete((EObject)this.pfRpl));
        new CapellaDeleteCommand(TransactionHelper.getExecutionManager((EObject)this.pfRpl), Collections.singleton(this.pfRpl), true, false, false).execute();
        BlackboxComplianceTest1.assertSame((Object)this.rootPf, (Object)this.pfRpl.eContainer());
        this.expectRollback(() -> {
            EcoreUtil.delete((EObject)alloc);
            EcoreUtil.delete((EObject)this.pfRpl);
        });
        new CapellaDeleteCommand(TransactionHelper.getExecutionManager((EObject)this.pfRpl), Arrays.asList(this.pfRpl, (CapellaElement)this.pfRpl.getComponentFunctionalAllocations().get(0)), true, false, false).execute();
        BlackboxComplianceTest1.assertSame((Object)this.rootPf, (Object)this.pfRpl.eContainer());
        BlackboxComplianceTest1.assertSame((Object)this.pcRpl, (Object)alloc.eContainer());
        new CapellaDeleteCommand(TransactionHelper.getExecutionManager((EObject)this.pfRec), Collections.singleton(this.pfRec), true, false, false).execute();
        BlackboxComplianceTest1.assertNull((Object)this.pfRec.eResource());
        BlackboxComplianceTest1.assertTrue((boolean)this.pcRec.getOwnedFunctionalAllocation().isEmpty());
        this.updateReplica(Collections.singleton(this.pcRpl), this.rpl);
        BlackboxComplianceTest1.assertNull((Object)this.pfRpl.eResource());
        BlackboxComplianceTest1.assertTrue((boolean)this.pcRpl.getAllocatedFunctions().isEmpty());
        BlackboxComplianceTest1.assertTrue((boolean)this.pcRpl.getOwnedFunctionalAllocation().isEmpty());
    }
}

