/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.refinement.ju.helpers;

import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.junit.Assert;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.helpers.interaction.services.AbstractEndExt;
import org.polarsys.capella.core.data.helpers.interaction.services.ScenarioExt;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.test.refinement.ju.helpers.Messages;

public class ScenarioTestHelper {
    public static void compareStructure(Scenario scenario1, Scenario scenario2) {
        for (EStructuralFeature feature : ScenarioExt.getElementOfInterestOnScenario()) {
            List elts1 = (List)scenario1.eGet(feature);
            List elts2 = (List)scenario2.eGet(feature);
            Assert.assertTrue((String)NLS.bind((String)Messages.differentNumberOfElement, (Object[])new Object[]{String.valueOf(elts1.size()), feature.getName()}), (elts1.size() == elts2.size() ? 1 : 0) != 0);
        }
    }

    public static void compareOrdering(Scenario scenario1, Scenario scenario2) {
        ScenarioTestHelper.compareOrder(scenario1, scenario2, InteractionPackage.Literals.SCENARIO__OWNED_INTERACTION_FRAGMENTS, new Comparator<EObject>(){

            @Override
            public int compare(EObject arg0, EObject arg1) {
                if (arg0 instanceof AbstractEnd && arg1 instanceof AbstractEnd) {
                    return AbstractEndExt.compareAbstractEnd((AbstractEnd)((AbstractEnd)arg0), (AbstractEnd)((AbstractEnd)arg1)) ? 0 : -1;
                }
                return 0;
            }
        }, NLS.bind((String)Messages.wrongOrderingOfAbstractEnds, null));
        ScenarioTestHelper.compareOrder(scenario1, scenario2, InteractionPackage.Literals.SCENARIO__OWNED_INSTANCE_ROLES, new Comparator<EObject>(){

            @Override
            public int compare(EObject arg0, EObject arg1) {
                return AbstractEndExt.compareInstanceRole((InstanceRole)((InstanceRole)arg0), (InstanceRole)((InstanceRole)arg1)) ? 0 : -1;
            }
        }, NLS.bind((String)Messages.wrongOrderingOfInstanceRoles, null));
    }

    protected static void compareOrder(Scenario scenario1, Scenario scenario2, EReference feature, Comparator<EObject> comparator, String message) {
        List elts1 = (List)scenario1.eGet((EStructuralFeature)feature);
        List elts2 = (List)scenario2.eGet((EStructuralFeature)feature);
        if (elts1.size() == elts2.size()) {
            int i = 0;
            while (i < elts1.size()) {
                EObject ae2;
                EObject ae1 = (EObject)elts1.get(i);
                Assert.assertTrue((String)message, (comparator.compare(ae1, ae2 = (EObject)elts2.get(i)) == 0 ? 1 : 0) != 0);
                ++i;
            }
        }
    }

    public static void checkMergeLink(Scenario sc) {
        ScenarioTestHelper.checkLink(sc, InteractionPackage.Literals.MERGE_LINK, (EStructuralFeature)ModellingcorePackage.Literals.TRACEABLE_ELEMENT__OUTGOING_TRACES, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT, Messages.noMergeLink);
    }

    public static void checkRefinementLink(Scenario sc) {
        ScenarioTestHelper.checkLink(sc, InteractionPackage.Literals.REFINEMENT_LINK, (EStructuralFeature)ModellingcorePackage.Literals.TRACEABLE_ELEMENT__OUTGOING_TRACES, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT, Messages.noRefinementLink);
    }

    public static void checkLink(Scenario sc, EClass linkType, EStructuralFeature feature1, EStructuralFeature feature2, String errorMessagePattern) {
        List list = ScenarioExt.hasLinkOftype((TraceableElement)sc, (EClass)linkType, (EStructuralFeature)feature1, (EStructuralFeature)feature2);
        TraceableElement result = list.isEmpty() ? null : (TraceableElement)list.get(0);
        Assert.assertNotNull((String)NLS.bind((String)errorMessagePattern, (Object[])new Object[]{sc.eClass().getName(), sc.getName()}), (Object)result);
        List features = ScenarioExt.getElementOfInterestOnScenario();
        for (EStructuralFeature feature : features) {
            for (Object elt : (List)sc.eGet(feature)) {
                list = ScenarioExt.hasLinkOftype((TraceableElement)((TraceableElement)elt), (EClass)linkType, (EStructuralFeature)feature1, (EStructuralFeature)feature2);
                result = list.isEmpty() ? null : (TraceableElement)list.get(0);
                Assert.assertNotNull((String)NLS.bind((String)errorMessagePattern, (Object[])new Object[]{((EObject)elt).eClass().getName(), elt instanceof NamedElement ? ((NamedElement)elt).getName() : Messages.na}), (Object)result);
            }
        }
    }
}

