/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.refinement.ju.testcases;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.junit.Assert;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.MergeLink;
import org.polarsys.capella.core.data.interaction.RefinementLink;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.refinement.RefinementMultiple;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ProcessorException;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.EObjectHelper;
import org.polarsys.capella.test.framework.helpers.TestHelper;
import org.polarsys.capella.test.refinement.ju.Messages;
import org.polarsys.capella.test.refinement.ju.headless.HeadlessResultProvider;
import org.polarsys.capella.test.refinement.ju.headless.IResolverResult;
import org.polarsys.capella.test.refinement.ju.helpers.ScenarioTestHelper;

public abstract class RefinementTest
extends BasicTestCase {
    protected List<String> _additionalElementsId;
    protected List<List<String>> _ambiguitiesProposalsId;
    protected List<String> _ambiguityChoicesId;
    protected List<String> _refinementTargetProposalsId;
    protected List<String> _refinementTargetsChoiceId;
    protected List<String> _scenarioReferenceIds;
    protected List<String> _scenarioToRefineIds;
    protected Map<String, EObject> _semanticObjectMap;

    public RefinementTest(List<String> refinementTargetsChoiceId, List<String> refinementTargetProposalsId, String scenarioToRefineId, String scenarioReferenceId, List<String> ambiguityChoicesId, List<List<String>> ambiguitiesProposalsId, List<String> additionalElementsId) {
        this._scenarioToRefineIds = Arrays.asList(scenarioToRefineId.split(","));
        this._scenarioReferenceIds = Arrays.asList(scenarioReferenceId.split(","));
        this._ambiguityChoicesId = ambiguityChoicesId;
        this._ambiguitiesProposalsId = ambiguitiesProposalsId;
        this._refinementTargetsChoiceId = refinementTargetsChoiceId;
        this._refinementTargetProposalsId = refinementTargetProposalsId;
        this._additionalElementsId = additionalElementsId;
    }

    public void test() throws Exception {
        this.refinementTest();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setObjects();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this._semanticObjectMap.clear();
        this._semanticObjectMap = null;
    }

    protected void additionalCheck(Scenario refinedScenario, Scenario referenceScenario) {
    }

    protected Scenario getRefinedScenario(Scenario scenario, NamedElement target) {
        if (scenario != null) {
            for (AbstractTrace abstractTrace : scenario.getIncomingTraces()) {
                TraceableElement traceableElement;
                if (abstractTrace instanceof RefinementLink) {
                    traceableElement = abstractTrace.getSourceElement();
                    if (!(traceableElement instanceof Scenario) || target != null && !EcoreUtil2.isContainedBy((EObject)traceableElement, (EObject)(target instanceof AbstractInstance ? ((AbstractInstance)target).getAbstractType() : target))) continue;
                    return (Scenario)traceableElement;
                }
                if (!(abstractTrace instanceof MergeLink) || !((traceableElement = abstractTrace.getSourceElement()) instanceof Scenario)) continue;
                return this.getRefinedScenario((Scenario)traceableElement, target);
            }
        }
        return null;
    }

    public void refinementTest() {
        final Scenario scenario = (Scenario)this._semanticObjectMap.get(this._scenarioToRefineIds.get(0));
        Scenario reference = (Scenario)this._semanticObjectMap.get(this._scenarioReferenceIds.get(0));
        final ArrayList<NamedElement> targets = new ArrayList<NamedElement>();
        for (String target : this._refinementTargetsChoiceId) {
            targets.add((NamedElement)this._semanticObjectMap.get(target));
        }
        final ArrayList<NamedElement> possibleTargets = new ArrayList<NamedElement>();
        for (String possibleTarget : this._refinementTargetProposalsId) {
            EObject obj = this._semanticObjectMap.get(possibleTarget);
            if (obj == null) continue;
            possibleTargets.add((NamedElement)obj);
        }
        if (scenario != null && reference != null) {
            AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){
                private RefinementMultiple refinement;

                public Collection<?> getAffectedObjects() {
                    Object result = this.refinement.getResult();
                    if (result instanceof Collection) {
                        return (Collection)result;
                    }
                    return Collections.singleton(result);
                }

                public void run() {
                    try {
                        this.refinement = new RefinementMultiple((NamedElement)scenario){
                            boolean skipSelection;
                            {
                                super($anonymous0);
                                this.skipSelection = false;
                            }

                            protected Map<NamedElement, List<NamedElement>> evaluateTarget(List<Scenario> scenarios) {
                                this.skipSelection = true;
                                Map result = super.evaluateTarget(scenarios);
                                for (Scenario sc : scenarios) {
                                    List evaluatedTargets = (List)result.get(sc);
                                    if (evaluatedTargets == null) continue;
                                    Assert.assertTrue((String)Messages.wrongRefinementTargets, (evaluatedTargets.size() == possibleTargets.size() ? 1 : 0) != 0);
                                    Assert.assertTrue((String)Messages.wrongRefinementTargets, (boolean)evaluatedTargets.containsAll(targets));
                                    Assert.assertTrue((String)Messages.wrongRefinementTargets, (boolean)possibleTargets.containsAll(targets));
                                }
                                this.skipSelection = false;
                                return super.evaluateTarget(scenarios);
                            }

                            protected Map<NamedElement, List<NamedElement>> selectTarget(Map<NamedElement, List<NamedElement>> allTargets) {
                                if (this.skipSelection) {
                                    return allTargets;
                                }
                                if (!targets.isEmpty()) {
                                    HashMap<NamedElement, List<NamedElement>> result = new HashMap<NamedElement, List<NamedElement>>();
                                    ArrayList selectedTargets = new ArrayList();
                                    List<NamedElement> lst = allTargets.get(scenario);
                                    if (lst.containsAll(targets)) {
                                        selectedTargets.addAll(targets);
                                    }
                                    result.put((NamedElement)scenario, selectedTargets);
                                    return result;
                                }
                                return super.selectTarget(allTargets);
                            }
                        };
                        this.refinement.execute();
                    }
                    catch (ProcessorException exception) {
                        Assert.fail((String)Messages.refinementDoesNotSucceed);
                    }
                }
            };
            TestHelper.getExecutionManager((EObject)scenario).execute((ICommand)cmd);
            for (NamedElement target : targets) {
                Scenario refinedScenario = this.getRefinedScenario(scenario, target);
                if (refinedScenario != null) {
                    ScenarioTestHelper.compareStructure(refinedScenario, reference);
                    ScenarioTestHelper.compareOrdering(refinedScenario, reference);
                    ScenarioTestHelper.checkRefinementLink(refinedScenario);
                    this.additionalCheck(refinedScenario, reference);
                    continue;
                }
                Assert.fail((String)Messages.noRefinedScenarioCreated);
            }
        } else {
            Assert.fail((String)Messages.modelCannotbeLoaded);
        }
    }

    protected void setObjects() {
        this._semanticObjectMap = new HashMap<String, EObject>();
        Resource semanticResource = TestHelper.getSemanticResource((Session)this.getSession((String)this.getRequiredTestModels().get(0)));
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this._scenarioToRefineIds);
        list.addAll(this._scenarioReferenceIds);
        list.addAll(this._refinementTargetsChoiceId);
        list.addAll(this._refinementTargetProposalsId);
        list.addAll(this._ambiguityChoicesId);
        for (List<String> ids : this._ambiguitiesProposalsId) {
            list.addAll(ids);
        }
        list.addAll(this._additionalElementsId);
        Map map = EObjectHelper.getMatchingEObject((EObject)((EObject)semanticResource.getContents().get(0)), (EClass)ModellingcorePackage.Literals.MODEL_ELEMENT, (EStructuralFeature)ModellingcorePackage.Literals.MODEL_ELEMENT__ID, list);
        this._semanticObjectMap.putAll(map);
        IResolverResult result = new IResolverResult(){
            private int _counter1 = 0;
            private int _counter2 = 0;

            @Override
            public List<AbstractInstance> getAttemptedAbstractInstances() {
                ArrayList<AbstractInstance> attemptedList = new ArrayList<AbstractInstance>();
                List<String> attemptedIds = RefinementTest.this._ambiguitiesProposalsId.get(this._counter2++);
                for (String id : attemptedIds) {
                    EObject obj = RefinementTest.this._semanticObjectMap.get(id);
                    if (!(obj instanceof AbstractInstance)) continue;
                    attemptedList.add((AbstractInstance)obj);
                }
                return attemptedList;
            }

            @Override
            public List<AbstractInstance> getSelectedAbstractInstances() {
                String id;
                EObject obj;
                ArrayList<AbstractInstance> selection = new ArrayList<AbstractInstance>();
                if ((obj = RefinementTest.this._semanticObjectMap.get(id = RefinementTest.this._ambiguityChoicesId.get(this._counter1++))) instanceof AbstractInstance) {
                    selection.add((AbstractInstance)obj);
                }
                return selection;
            }
        };
        HeadlessResultProvider.INSTANCE.setCurrentResult(result);
    }
}

